/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ide.konan;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ide.konan.decompiler.KotlinNativeLoadingMetadataCache;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.library.KonanLibraryLayout;
import org.jetbrains.kotlin.konan.library.KonanLibrarySource;
import org.jetbrains.kotlin.konan.library.MetadataReader;
import org.jetbrains.kotlin.metadata.konan.KonanProtoBuf;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ide/konan/CachingIdeMetadataReaderImpl;", "Lorg/jetbrains/kotlin/konan/library/MetadataReader;", "()V", "cache", "Lorg/jetbrains/kotlin/ide/konan/decompiler/KotlinNativeLoadingMetadataCache;", "getCache", "()Lorg/jetbrains/kotlin/ide/konan/decompiler/KotlinNativeLoadingMetadataCache;", "asJarFileSystemFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "jarFile", "Lorg/jetbrains/kotlin/konan/file/File;", "localFile", "asLocalFile", "loadSerializedModule", "Lorg/jetbrains/kotlin/metadata/konan/KonanProtoBuf$LinkDataLibrary;", "libraryLayout", "Lorg/jetbrains/kotlin/konan/library/KonanLibraryLayout;", "loadSerializedPackageFragment", "Lorg/jetbrains/kotlin/metadata/konan/KonanProtoBuf$LinkDataPackageFragment;", "packageFqName", "", "partName", "getVirtualFile", "file", "idea-native"})
public final class CachingIdeMetadataReaderImpl
implements MetadataReader {
    public static final CachingIdeMetadataReaderImpl INSTANCE;

    @Override
    @NotNull
    public KonanProtoBuf.LinkDataLibrary loadSerializedModule(@NotNull KonanLibraryLayout libraryLayout) {
        Intrinsics.checkParameterIsNotNull((Object)libraryLayout, (String)"libraryLayout");
        return this.getCache().getCachedModuleHeader(this.getVirtualFile(libraryLayout, libraryLayout.getModuleHeaderFile()));
    }

    @Override
    @NotNull
    public KonanProtoBuf.LinkDataPackageFragment loadSerializedPackageFragment(@NotNull KonanLibraryLayout libraryLayout, @NotNull String packageFqName, @NotNull String partName) {
        Intrinsics.checkParameterIsNotNull((Object)libraryLayout, (String)"libraryLayout");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
        return this.getCache().getCachedPackageFragment(this.getVirtualFile(libraryLayout, libraryLayout.packageFragmentFile(packageFqName, partName)));
    }

    private final VirtualFile getVirtualFile(@NotNull KonanLibraryLayout $receiver, File file) {
        VirtualFile virtualFile;
        KonanLibrarySource source = $receiver.getSource();
        KonanLibrarySource konanLibrarySource = source;
        if (konanLibrarySource instanceof KonanLibrarySource.KonanLibraryFile) {
            virtualFile = this.asJarFileSystemFile(((KonanLibrarySource.KonanLibraryFile)source).getKlibFile(), file);
        } else if (konanLibrarySource instanceof KonanLibrarySource.KonanLibraryDir) {
            virtualFile = this.asLocalFile(file);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return virtualFile;
    }

    private final VirtualFile asJarFileSystemFile(File jarFile, File localFile) {
        String fullPath = jarFile.getAbsolutePath() + "!" + localFile.getAbsolutePath();
        VirtualFile virtualFile = StandardFileSystems.jar().findFileByPath(fullPath);
        if (virtualFile == null) {
            String string = "File not found: " + fullPath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    private final VirtualFile asLocalFile(File localFile) {
        String fullPath = localFile.getAbsolutePath();
        VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(fullPath);
        if (virtualFile == null) {
            String string = "File not found: " + fullPath;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    private final KotlinNativeLoadingMetadataCache getCache() {
        return KotlinNativeLoadingMetadataCache.Companion.getInstance();
    }

    private CachingIdeMetadataReaderImpl() {
    }

    static {
        CachingIdeMetadataReaderImpl cachingIdeMetadataReaderImpl;
        INSTANCE = cachingIdeMetadataReaderImpl = new CachingIdeMetadataReaderImpl();
    }
}

