/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinClassifierInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "qualifiedName", "", "lookupObject", "Lorg/jetbrains/kotlin/idea/core/completion/DeclarationLookupObject;", "idea"})
public final class KotlinClassifierInsertHandler
extends BaseDeclarationInsertHandler {
    public static final KotlinClassifierInsertHandler INSTANCE;

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context);
        super.handleInsert(context, item);
        PsiFile psiFile = context.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"context.file");
        PsiFile file = psiFile;
        if (file instanceof KtFile && !CompletionUtilsKt.isAfterDot(context)) {
            boolean isAnnotation;
            KtNameReferenceExpression nameRef;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            psiDocumentManager.commitAllDocuments();
            int startOffset = context.getStartOffset();
            Document document = context.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
            Document document2 = document;
            Object object = item.getObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject");
            }
            DeclarationLookupObject lookupObject2 = (DeclarationLookupObject)object;
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor != null) {
                if (CompletionUtilsKt.isArtificialImportAliasedDescriptor(declarationDescriptor)) {
                    return;
                }
            }
            String qualifiedName2 = this.qualifiedName(lookupObject2);
            PsiElement psiElement2 = file.findElementAt(startOffset);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(startOffset)!!");
            PsiElement token = psiElement2;
            PsiElement psiElement3 = token.getParent();
            if (!(psiElement3 instanceof KtNameReferenceExpression)) {
                psiElement3 = null;
            }
            if ((nameRef = (KtNameReferenceExpression)psiElement3) != null) {
                ClassifierDescriptorWithTypeParameters target;
                BindingContext bindingContext2 = ResolutionUtils.analyze(nameRef, BodyResolveMode.PARTIAL);
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, nameRef);
                if (classifierDescriptorWithTypeParameters == null) {
                    Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
                    if (!(v instanceof ClassDescriptor)) {
                        v = null;
                    }
                    classifierDescriptorWithTypeParameters = target = (ClassifierDescriptorWithTypeParameters)((ClassDescriptor)v);
                }
                if (target != null && Intrinsics.areEqual((Object)IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(target), (Object)qualifiedName2)) {
                    return;
                }
            }
            String tempPrefix = nameRef != null ? ((isAnnotation = CallTypeAndReceiver.Companion.detect(nameRef) instanceof CallTypeAndReceiver.ANNOTATION) ? "" : " ") : "$;val v:";
            String tempSuffix = ".xxx";
            document2.replaceString(startOffset, context.getTailOffset(), (CharSequence)(tempPrefix + qualifiedName2 + tempSuffix));
            psiDocumentManager.commitAllDocuments();
            int classNameStart = startOffset + tempPrefix.length();
            int classNameEnd = classNameStart + qualifiedName2.length();
            RangeMarker rangeMarker = document2.createRangeMarker(classNameStart, classNameEnd);
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker, (String)"document.createRangeMark\u2026sNameStart, classNameEnd)");
            RangeMarker rangeMarker2 = rangeMarker;
            RangeMarker rangeMarker3 = document2.createRangeMarker(startOffset, classNameEnd + tempSuffix.length());
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker3, (String)"document.createRangeMark\u2026eEnd + tempSuffix.length)");
            RangeMarker wholeRangeMarker = rangeMarker3;
            ShortenReferences.DEFAULT.process((KtFile)file, classNameStart, classNameEnd);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
            if (rangeMarker2.isValid() && wholeRangeMarker.isValid()) {
                document2.deleteString(wholeRangeMarker.getStartOffset(), rangeMarker2.getStartOffset());
                document2.deleteString(rangeMarker2.getEndOffset(), wholeRangeMarker.getEndOffset());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String qualifiedName(DeclarationLookupObject lookupObject2) {
        Object object;
        if (lookupObject2.getDescriptor() != null) {
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
            }
            object = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName((ClassifierDescriptor)declarationDescriptor);
        } else {
            void var2_2;
            PsiElement psiElement2 = lookupObject2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
            }
            String string = ((PsiClass)psiElement2).getQualifiedName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(lookupObject.psiElement\u2026PsiClass).qualifiedName!!");
            String qualifiedName2 = string;
            object = FqNameUnsafe.isValid(qualifiedName2) ? RenderingUtilsKt.render(new FqNameUnsafe(qualifiedName2)) : var2_2;
        }
        return object;
    }

    private KotlinClassifierInsertHandler() {
    }

    static {
        KotlinClassifierInsertHandler kotlinClassifierInsertHandler;
        INSTANCE = kotlinClassifierInsertHandler = new KotlinClassifierInsertHandler();
    }
}

