/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.LambdaSignatureTemplates;
import org.jetbrains.kotlin.idea.completion.handlers.GenerateLambdaInfo;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0013\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Infix", "Normal", "OnlyName", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Infix;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$OnlyName;", "idea"})
public abstract class KotlinFunctionInsertHandler
extends KotlinCallableInsertHandler {
    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.handleInsert(context, item);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
        psiDocumentManager.commitAllDocuments();
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(context.getDocument());
    }

    private KotlinFunctionInsertHandler(CallType<?> callType) {
        super(callType);
    }

    public /* synthetic */ KotlinFunctionInsertHandler(@NotNull CallType callType, DefaultConstructorMarker $constructor_marker) {
        this(callType);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JH\u0010\u001b\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Normal;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "inputTypeArguments", "", "inputValueArguments", "argumentText", "", "lambdaInfo", "Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;", "argumentsOnly", "(Lorg/jetbrains/kotlin/idea/util/CallType;ZZLjava/lang/String;Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;Z)V", "getArgumentText", "()Ljava/lang/String;", "getArgumentsOnly", "()Z", "getInputTypeArguments", "getInputValueArguments", "getLambdaInfo", "()Lorg/jetbrains/kotlin/idea/completion/handlers/GenerateLambdaInfo;", "addArguments", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "offsetElement", "Lcom/intellij/psi/PsiElement;", "copy", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isInsertSpacesInOneLineFunctionEnabled", "project", "Lcom/intellij/openapi/project/Project;", "shouldPlaceCaretInBrackets", "completionChar", "", "idea"})
    public static final class Normal
    extends KotlinFunctionInsertHandler {
        private final boolean inputTypeArguments;
        private final boolean inputValueArguments;
        @NotNull
        private final String argumentText;
        @Nullable
        private final GenerateLambdaInfo lambdaInfo;
        private final boolean argumentsOnly;

        @NotNull
        public final Normal copy(@NotNull CallType<?> callType, boolean inputTypeArguments, boolean inputValueArguments, @NotNull String argumentText2, @Nullable GenerateLambdaInfo lambdaInfo, boolean argumentsOnly) {
            Intrinsics.checkParameterIsNotNull(callType, (String)"callType");
            Intrinsics.checkParameterIsNotNull((Object)argumentText2, (String)"argumentText");
            return new Normal(callType, inputTypeArguments, inputValueArguments, argumentText2, lambdaInfo, argumentsOnly);
        }

        @NotNull
        public static /* synthetic */ Normal copy$default(Normal normal, CallType callType, boolean bl, boolean bl2, String string, GenerateLambdaInfo generateLambdaInfo, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                callType = normal.getCallType();
            }
            if ((n & 2) != 0) {
                bl = normal.inputTypeArguments;
            }
            if ((n & 4) != 0) {
                bl2 = normal.inputValueArguments;
            }
            if ((n & 8) != 0) {
                string = normal.argumentText;
            }
            if ((n & 0x10) != 0) {
                generateLambdaInfo = normal.lambdaInfo;
            }
            if ((n & 0x20) != 0) {
                bl3 = normal.argumentsOnly;
            }
            return normal.copy(callType, bl, bl2, string, generateLambdaInfo, bl3);
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context.getProject());
            Document document = context.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
            Document document2 = document;
            if (!this.argumentsOnly) {
                HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context);
                super.handleInsert(context, item);
            }
            psiDocumentManager.commitAllDocuments();
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document2);
            int startOffset = context.getStartOffset();
            PsiElement psiElement2 = context.getFile().findElementAt(startOffset);
            if (psiElement2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"context.file.findElementAt(startOffset) ?: return");
            PsiElement element3 = psiElement2;
            this.addArguments(context, element3);
        }

        private final void addArguments(InsertionContext context, PsiElement offsetElement) {
            Integer n;
            Integer openingBracketOffset;
            Integer parent2;
            int offset1;
            boolean insertTypeArguments;
            char completionChar = context.getCompletionChar();
            if (completionChar == '(') {
                context.setAddCompletionChar(false);
            }
            int offset2 = context.getTailOffset();
            Document document = context.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"context.document");
            Document document2 = document;
            Editor editor = context.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"context.editor");
            Editor editor2 = editor;
            Project project = context.getProject();
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"document.charsSequence");
            CharSequence chars = charSequence;
            boolean insertLambda = this.lambdaInfo != null && completionChar != '(' && (completionChar != '\t' || !HandlerUtilsKt.isCharAt(chars, offset2, '('));
            char openingBracket = insertLambda ? (char)'{' : '(';
            char closingBracket = insertLambda ? (char)'}' : ')';
            boolean bl = insertTypeArguments = this.inputTypeArguments && (completionChar == '\n' || completionChar == '\r' || completionChar == '\t');
            if (completionChar == '\t' && (offset1 = HandlerUtilsKt.skipSpaces(chars, offset2)) < chars.length() && chars.charAt(offset1) == '<') {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                PsiElement psiElement2 = context.getFile().findElementAt(offset1);
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"context.file.findElementAt(offset1)!!");
                PsiElement token = psiElement2;
                ASTNode aSTNode = token.getNode();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"token.node");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.LT)) && (parent2 = token.getParent()) instanceof KtTypeArgumentList) {
                    String string = parent2.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parent.getText()");
                    if (StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null) < 0) {
                        offset2 = PsiUtilsKt.getEndOffset((PsiElement)parent2);
                        insertTypeArguments = false;
                    }
                }
            }
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                if (generateLambdaInfo == null) {
                    Intrinsics.throwNpe();
                }
                if (generateLambdaInfo.getExplicitParameters()) {
                    insertTypeArguments = false;
                }
            }
            if (insertTypeArguments) {
                document2.insertString(offset2, (CharSequence)"<>");
                editor2.getCaretModel().moveToOffset(offset2 + 1);
                offset2 += 2;
            }
            Integer n2 = openingBracketOffset = HandlerUtilsKt.indexOfSkippingSpace(chars, openingBracket, offset2);
            if (n2 != null) {
                parent2 = n2;
                int it = ((Number)parent2).intValue();
                n = HandlerUtilsKt.indexOfSkippingSpace(chars, closingBracket, it + 1);
            } else {
                n = null;
            }
            Integer closeBracketOffset = n;
            int inBracketsShift = 0;
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                if (generateLambdaInfo == null) {
                    Intrinsics.throwNpe();
                }
                if (generateLambdaInfo.getExplicitParameters() && closeBracketOffset == null) {
                    openingBracketOffset = null;
                }
            }
            if (openingBracketOffset == null) {
                if (insertLambda) {
                    if (completionChar == ' ' || completionChar == '{') {
                        context.setAddCompletionChar(false);
                    }
                    Project project2 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    if (this.isInsertSpacesInOneLineFunctionEnabled(project2)) {
                        document2.insertString(offset2, (CharSequence)" {  }");
                        inBracketsShift = 1;
                    } else {
                        document2.insertString(offset2, (CharSequence)" {}");
                    }
                } else {
                    document2.insertString(offset2, (CharSequence)"()");
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
                Integer n3 = HandlerUtilsKt.indexOfSkippingSpace(chars, openingBracket, offset2);
                if (n3 == null) {
                    Intrinsics.throwNpe();
                }
                openingBracketOffset = n3;
                Integer n4 = HandlerUtilsKt.indexOfSkippingSpace(chars, closingBracket, openingBracketOffset + 1);
                if (n4 == null) {
                    Intrinsics.throwNpe();
                }
                closeBracketOffset = n4;
            }
            if (insertLambda) {
                GenerateLambdaInfo generateLambdaInfo = this.lambdaInfo;
                if (generateLambdaInfo == null) {
                    Intrinsics.throwNpe();
                }
                if (generateLambdaInfo.getExplicitParameters()) {
                    int n5 = openingBracketOffset;
                    Integer n6 = closeBracketOffset;
                    if (n6 == null) {
                        Intrinsics.throwNpe();
                    }
                    TextRange placeholderRange = new TextRange(n5, n6 + 1);
                    PsiFile psiFile = context.getFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    boolean explicitParameterTypes = LambdaSignatureTemplates.INSTANCE.explicitParameterTypesRequired((KtFile)psiFile, placeholderRange, this.lambdaInfo.getLambdaType());
                    LambdaSignatureTemplates.INSTANCE.insertTemplate(context, placeholderRange, this.lambdaInfo.getLambdaType(), explicitParameterTypes, false);
                    return;
                }
            }
            document2.insertString(openingBracketOffset + 1, (CharSequence)this.argumentText);
            if (closeBracketOffset != null) {
                closeBracketOffset = closeBracketOffset + this.argumentText.length();
            }
            if (!insertTypeArguments) {
                if (this.shouldPlaceCaretInBrackets(completionChar) || closeBracketOffset == null) {
                    editor2.getCaretModel().moveToOffset(openingBracketOffset + 1 + inBracketsShift);
                    if (!insertLambda) {
                        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
                        if (autoPopupController != null) {
                            autoPopupController.autoPopupParameterInfo(editor2, offsetElement);
                        }
                    }
                } else {
                    editor2.getCaretModel().moveToOffset(closeBracketOffset + 1);
                }
            }
        }

        private final boolean shouldPlaceCaretInBrackets(char completionChar) {
            if (completionChar == ',' || completionChar == '.' || completionChar == '=') {
                return false;
            }
            if (completionChar == '(') {
                return true;
            }
            return this.inputValueArguments || this.lambdaInfo != null;
        }

        private final boolean isInsertSpacesInOneLineFunctionEnabled(Project project) {
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(KotlinCodeStyleSettings.class);
            if (customCodeStyleSettings == null) {
                Intrinsics.throwNpe();
            }
            return ((KotlinCodeStyleSettings)customCodeStyleSettings).INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD;
        }

        public final boolean getInputTypeArguments() {
            return this.inputTypeArguments;
        }

        public final boolean getInputValueArguments() {
            return this.inputValueArguments;
        }

        @NotNull
        public final String getArgumentText() {
            return this.argumentText;
        }

        @Nullable
        public final GenerateLambdaInfo getLambdaInfo() {
            return this.lambdaInfo;
        }

        public final boolean getArgumentsOnly() {
            return this.argumentsOnly;
        }

        public Normal(@NotNull CallType<?> callType, boolean inputTypeArguments, boolean inputValueArguments, @NotNull String argumentText2, @Nullable GenerateLambdaInfo lambdaInfo, boolean argumentsOnly) {
            Intrinsics.checkParameterIsNotNull(callType, (String)"callType");
            Intrinsics.checkParameterIsNotNull((Object)argumentText2, (String)"argumentText");
            super(callType, null);
            this.inputTypeArguments = inputTypeArguments;
            this.inputValueArguments = inputValueArguments;
            this.argumentText = argumentText2;
            this.lambdaInfo = lambdaInfo;
            this.argumentsOnly = argumentsOnly;
            if (this.lambdaInfo != null) {
                boolean bl = Intrinsics.areEqual((Object)this.argumentText, (Object)"");
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }
        }

        public /* synthetic */ Normal(CallType callType, boolean bl, boolean bl2, String string, GenerateLambdaInfo generateLambdaInfo, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = "";
            }
            if ((n & 0x10) != 0) {
                generateLambdaInfo = null;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            this(callType, bl, bl2, string, generateLambdaInfo, bl3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$Infix;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "idea"})
    public static final class Infix
    extends KotlinFunctionInsertHandler {
        public static final Infix INSTANCE;

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            super.handleInsert(context, item);
            if (context.getCompletionChar() == ' ') {
                context.setAddCompletionChar(false);
            }
            int tailOffset = context.getTailOffset();
            context.getDocument().insertString(tailOffset, (CharSequence)" ");
            Editor editor = context.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"context.editor");
            editor.getCaretModel().moveToOffset(tailOffset + 1);
        }

        private Infix() {
            super(CallType.INFIX.INSTANCE, null);
        }

        static {
            Infix infix;
            INSTANCE = infix = new Infix();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler$OnlyName;", "Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinFunctionInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "idea"})
    public static final class OnlyName
    extends KotlinFunctionInsertHandler {
        public OnlyName(@NotNull CallType<?> callType) {
            Intrinsics.checkParameterIsNotNull(callType, (String)"callType");
            super(callType, null);
        }
    }
}

