/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleModuleConfigurator;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u0012\u001a\u00020\u0003H\u0014J\b\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0003H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinFrameworkSupportProvider;", "frameworkTypeId", "", "displayName", "(Ljava/lang/String;Ljava/lang/String;)V", "addSupport", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "specifyPluginVersionIfNeeded", "", "getDependencies", "", "getDescription", "getPluginExpression", "getPluginId", "idea-gradle"})
public class GradleKotlinJavaFrameworkSupportProvider
extends GradleKotlinFrameworkSupportProvider {
    @Override
    @NotNull
    protected String getPluginId() {
        return KotlinGradleModuleConfigurator.Companion.getKOTLIN();
    }

    @Override
    @NotNull
    protected String getPluginExpression() {
        return "id 'org.jetbrains.kotlin.jvm'";
    }

    @Override
    @NotNull
    protected List<String> getDependencies(@Nullable Sdk sdk2) {
        return CollectionsKt.listOf((Object)KotlinRuntimeLibraryUtilKt.getStdlibArtifactId(sdk2, KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion()));
    }

    @Override
    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module, @Nullable Sdk sdk2, boolean specifyPluginVersionIfNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        super.addSupport(buildScriptData, module, sdk2, specifyPluginVersionIfNeeded);
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(sdk2, KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion());
        if (jvmTarget != null) {
            String description2 = jvmTarget.getDescription();
            buildScriptData.addOther("compileKotlin {\n    kotlinOptions.jvmTarget = \"" + description2 + "\"\n}\n\n");
            buildScriptData.addOther("compileTestKotlin {\n    kotlinOptions.jvmTarget = \"" + description2 + "\"\n}\n");
        }
    }

    @Override
    @NotNull
    protected String getDescription() {
        return "A Kotlin library or application targeting the JVM";
    }

    public GradleKotlinJavaFrameworkSupportProvider(@NotNull String frameworkTypeId, @NotNull String displayName) {
        Intrinsics.checkParameterIsNotNull((Object)frameworkTypeId, (String)"frameworkTypeId");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Icon icon = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"KotlinIcons.SMALL_LOGO");
        super(frameworkTypeId, displayName, icon);
    }

    public /* synthetic */ GradleKotlinJavaFrameworkSupportProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "KOTLIN";
        }
        if ((n & 2) != 0) {
            string2 = "Kotlin (Java)";
        }
        this(string, string2);
    }

    public GradleKotlinJavaFrameworkSupportProvider() {
        this(null, null, 3, null);
    }
}

