/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgumentKt;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0002H\u0016J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\u0005*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveLambdaOutsideParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "verb", "getVerb", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionTarget", "Lorg/jetbrains/kotlin/psi/KtElement;", "inspectionText", "isApplicable", "", "withInformationLevel", "idea"})
public final class MoveLambdaOutsideParenthesesInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    @NotNull
    private final String defaultFixText = "Move lambda argument out of parentheses";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean withInformationLevel(@NotNull KtCallExpression $receiver) {
        void var3_3;
        List<KtValueArgument> list2 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.lastOrNull(list2);
        if (ktValueArgument != null) {
            if (ktValueArgument.isNamed()) {
                return true;
            }
        }
        List<KtValueArgument> list3 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"valueArguments");
        Iterable $receiver$iv = list3;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            int n;
            KtValueArgument it = (KtValueArgument)element$iv;
            KtExpression ktExpression = it.getArgumentExpression();
            if (!((ktExpression != null ? KtLambdaArgumentKt.unpackFunctionLiteral$default(ktExpression, false, 1, null) : null) != null) || (n = ++count$iv) >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        boolean bl = var3_3;
        if (bl <= true) return false;
        return true;
    }

    private final String getVerb(@NotNull KtCallExpression $receiver) {
        return this.withInformationLevel($receiver) ? "can" : "should";
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.withInformationLevel(element3) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallExpression.class, (boolean)strict$iv);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression expression2 = ktCallExpression;
        if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(expression2)) {
            PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(expression2);
        }
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Lambda argument " + this.getVerb(element3) + " be moved out of parentheses";
    }

    @NotNull
    public KtElement inspectionTarget(@NotNull KtCallExpression element3) {
        PsiElement $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtElement ktElement = PsiModificationUtilsKt.getLastLambdaExpression(element3);
        if (ktElement == null || (ktElement = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = (PsiElement)ktElement), KtValueArgument.class, (boolean)true)) == null || (ktElement = ((KtValueArgument)ktElement).asElement()) == null) {
            ktElement = element3;
        }
        return ktElement;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    public MoveLambdaOutsideParenthesesInspection() {
        super(KtCallExpression.class);
    }
}

