/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.intentions.ConvertPropertyGetterToInitializerIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyGetterToInitializerIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertPropertyGetterToInitializerIntention
extends SelfTargetingIntention<KtPropertyAccessor> {
    @Override
    public boolean isApplicableTo(@NotNull KtPropertyAccessor element3, int caretOffset) {
        block6: {
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (!element3.isGetter() || ConvertPropertyGetterToInitializerIntentionKt.access$singleExpression(element3) == null) {
                    return false;
                }
                PsiElement psiElement2 = element3.getParent();
                if (!(psiElement2 instanceof KtProperty)) {
                    psiElement2 = null;
                }
                KtProperty ktProperty = (KtProperty)psiElement2;
                if (ktProperty == null) {
                    return false;
                }
                KtProperty property = ktProperty;
                if (property.hasInitializer() || property.getReceiverTypeReference() != null) break block5;
                KtClass ktClass2 = KtPsiUtilKt.containingClass(property);
                if (ktClass2 != null && ktClass2.isInterface()) break block5;
                DeclarationDescriptor declarationDescriptor = UtilsKt.getDescriptor(property);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) break block6;
                if (!propertyDescriptor.isExpect()) break block6;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTo(@NotNull KtPropertyAccessor element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) {
            return;
        }
        KtProperty property = ktProperty;
        CommentSaver commentSaver = new CommentSaver(property, false, 2, null);
        property.setInitializer(ConvertPropertyGetterToInitializerIntentionKt.access$singleExpression(element3));
        KtExpression ktExpression = property.getInitializer();
        property.deleteChildRange((PsiElement)(ktExpression != null ? ktExpression.getNextSibling() : null), element3);
        Editor editor2 = editor;
        if (editor2 != null && (editor2 = editor2.getCaretModel()) != null) {
            editor2.moveToOffset(PsiUtilsKt.getEndOffset(property));
        }
        CommentSaver.restore$default(commentSaver, property, false, 2, null);
    }

    public ConvertPropertyGetterToInitializerIntention() {
        super(KtPropertyAccessor.class, "Convert property getter to initializer", null, 4, null);
    }
}

