/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimIndentToTrimMarginIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimIndentToTrimMarginIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTrimIndentToTrimMarginIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertTrimIndentToTrimMarginIntention
extends SelfTargetingIntention<KtCallExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        boolean bl;
        block11: {
            KtStringTemplateExpression template2;
            block13: {
                block12: {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(element3);
                    KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
                    if (!(ktExpression instanceof KtStringTemplateExpression)) {
                        ktExpression = null;
                    }
                    KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
                    if (ktStringTemplateExpression == null) {
                        return false;
                    }
                    template2 = ktStringTemplateExpression;
                    String string = template2.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template.text");
                    if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                        return false;
                    }
                    KtExpression ktExpression2 = element3.getCalleeExpression();
                    if (ktExpression2 == null) {
                        return false;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.calleeExpression ?: return false");
                    KtExpression callee = ktExpression2;
                    if (Intrinsics.areEqual((Object)callee.getText(), (Object)"trimIndent") ^ true) break block12;
                    CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(callee);
                    if (!(Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(callableDescriptor) : null), (Object)new FqName("kotlin.text.trimIndent")) ^ true)) break block13;
                }
                return false;
            }
            Object[] objectArray = template2.getEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"template.entries");
            Object[] entries2 = objectArray;
            Iterable $receiver$iv = CollectionsKt.listOfNotNull((Object[])new KtStringTemplateEntry[]{(KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])entries2), (KtStringTemplateEntry)ArraysKt.lastOrNull((Object[])entries2)});
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
                    String string = it.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
                    if (ConvertTrimIndentToTrimMarginIntentionKt.access$isLineBreakOrBlank(string)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor) {
        KtStringTemplateEntry[] $receiver$iv;
        StringBuilder stringBuilder;
        String string;
        Object v4;
        void $receiver$iv2;
        KtQualifiedExpression qualifiedExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(element3);
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        Object[] objectArray = template2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"template.entries");
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)applyTo.indent.1.INSTANCE);
        Iterator iterator$iv = $receiver$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            String it = (String)minElem$iv;
            int minValue$iv = it.length();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                String it2 = (String)e$iv;
                int v$iv = it2.length();
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v4 = minElem$iv;
        }
        if ((string = (String)v4) == null) {
            string = "";
        }
        String indent2 = string;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        KtStringTemplateEntry[] ktStringTemplateEntryArray = template2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntryArray, (String)"template.entries");
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = $receiver$iv = ktStringTemplateEntryArray;
        int n = ktStringTemplateEntryArray2.length;
        for (int j = 0; j < n; ++j) {
            String text2;
            KtStringTemplateEntry element$iv;
            KtStringTemplateEntry entry;
            KtStringTemplateEntry ktStringTemplateEntry = entry = (element$iv = ktStringTemplateEntryArray2[j]);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"entry");
            String string2 = text2 = ktStringTemplateEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
            if (ConvertTrimIndentToTrimMarginIntentionKt.access$isLineBreakOrBlank(string2)) {
                $receiver.append(text2);
                continue;
            }
            $receiver.append(indent2);
            $receiver.append("|");
            $receiver.append(StringsKt.drop((String)text2, (int)indent2.length()));
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String newTemplate = string3;
        qualifiedExpression.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression("\"\"\"" + newTemplate + "\"\"\".trimMargin()"));
    }

    public ConvertTrimIndentToTrimMarginIntention() {
        super(KtCallExpression.class, "Convert to 'trimMargin'", null, 4, null);
    }
}

