/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualClassFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualFunctionFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualPropertyFix;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001fBF\b\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012%\u0010\t\u001a!\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\n\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0010H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R-\u0010\t\u001a!\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\n\u00a2\u0006\u0002\b\rX\u0088\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003 !\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix;", "D", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "declaration", "actualModule", "Lcom/intellij/openapi/module/Module;", "actualPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "generateIt", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;Lkotlin/jvm/functions/Function3;)V", "elementType", "", "getElementType", "()Ljava/lang/String;", "getFamilyName", "getOrCreateImplementationFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getText", "invoke", "", "project", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "startInWriteAction", "", "Companion", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualClassFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFunctionFix;", "idea"})
public abstract class CreateActualFix<D extends KtNamedDeclaration>
extends KotlinQuickFixAction<D> {
    private final Module actualModule;
    private final MultiTargetPlatform.Specific actualPlatform;
    private final Function3<KtPsiFactory, Project, D, D> generateIt;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    protected abstract String getElementType();

    @NotNull
    public String getText() {
        return "Create actual " + this.getElementType() + " for module " + this.actualModule.getName() + " (" + this.actualPlatform.getPlatform() + ')';
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected final void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration element3 = ktNamedDeclaration;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtFile ktFile = this.getOrCreateImplementationFile();
        if (ktFile == null) {
            return;
        }
        KtFile actualFile = ktFile;
        DumbService.getInstance((Project)project).runWhenSmart(new Runnable(this, factory2, project, element3, actualFile, file){
            final /* synthetic */ CreateActualFix this$0;
            final /* synthetic */ KtPsiFactory $factory;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtNamedDeclaration $element;
            final /* synthetic */ KtFile $actualFile;
            final /* synthetic */ KtFile $file;

            public final void run() {
                KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)CreateActualFix.access$getGenerateIt$p(this.this$0).invoke((Object)this.$factory, (Object)this.$project, (Object)this.$element);
                if (ktNamedDeclaration == null) {
                    return;
                }
                KtNamedDeclaration generated = ktNamedDeclaration;
                ApplicationUtilsKt.executeWriteCommand(this.$project, "Create actual declaration", (Function0<Unit>)((Function0)new Function0<Unit>(this, generated){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ KtNamedDeclaration $generated;

                    public final void invoke() {
                        block6: {
                            PsiElement reformatted;
                            KtPackageDirective ktPackageDirective = this.this$0.$actualFile.getPackageDirective();
                            KtPackageDirective ktPackageDirective2 = this.this$0.$file.getPackageDirective();
                            if (Intrinsics.areEqual((Object)(ktPackageDirective != null ? ktPackageDirective.getFqName() : null), (Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null)) ^ true && this.this$0.$actualFile.getDeclarations().isEmpty()) {
                                KtPackageDirective packageDirective;
                                KtPackageDirective ktPackageDirective3 = packageDirective = this.this$0.$file.getPackageDirective();
                                if (ktPackageDirective3 != null) {
                                    KtPackageDirective ktPackageDirective4;
                                    KtPackageDirective it = ktPackageDirective4 = ktPackageDirective3;
                                    KtPackageDirective oldPackageDirective = this.this$0.$actualFile.getPackageDirective();
                                    KtPsiFactory ktPsiFactory = this.this$0.$factory;
                                    FqName fqName2 = it.getFqName();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"it.fqName");
                                    KtPackageDirective newPackageDirective = ktPsiFactory.createPackageDirective(fqName2);
                                    if (oldPackageDirective != null) {
                                        oldPackageDirective.replace(newPackageDirective);
                                    } else {
                                        this.this$0.$actualFile.add(newPackageDirective);
                                    }
                                }
                            }
                            PsiElement psiElement2 = this.this$0.$actualFile.add(this.$generated);
                            if (psiElement2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                            }
                            KtElement actualDeclaration = (KtElement)psiElement2;
                            PsiElement psiElement3 = CodeStyleManager.getInstance((Project)this.this$0.$project).reformat((PsiElement)actualDeclaration);
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"CodeStyleManager.getInst\u2026format(actualDeclaration)");
                            PsiElement psiElement4 = reformatted = psiElement3;
                            if (psiElement4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                            }
                            KtElement shortened = ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement4, null, 2, null);
                            Editor editor = EditorHelper.openInEditor((PsiElement)((PsiElement)shortened));
                            if (editor == null || (editor = editor.getCaretModel()) == null) break block6;
                            TextRange textRange = shortened.getTextRange();
                            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"shortened.textRange");
                            editor.moveToOffset(textRange.getStartOffset());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$generated = ktNamedDeclaration;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = createActualFix;
                this.$factory = ktPsiFactory;
                this.$project = project;
                this.$element = ktNamedDeclaration;
                this.$actualFile = ktFile;
                this.$file = ktFile2;
            }
        });
    }

    private final KtFile getOrCreateImplementationFile() {
        Object t = this.getElement();
        if (!(t instanceof KtNamedDeclaration)) {
            t = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)t;
        if (ktNamedDeclaration == null) {
            return null;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        PsiElement parent2 = declaration2.getParent();
        if (parent2 instanceof KtFile) {
            for (KtDeclaration otherDeclaration : ((KtFile)parent2).getDeclarations()) {
                if (otherDeclaration == declaration2 || !PsiUtilsKt.hasExpectModifier(otherDeclaration)) continue;
                KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.singleOrNull((Iterable)ExpectActualUtilKt.actualsForExpected(otherDeclaration, this.actualModule));
                if (ktDeclaration == null) {
                    continue;
                }
                KtDeclaration actualDeclaration = ktDeclaration;
                return actualDeclaration.getContainingKtFile();
            }
        }
        String string = declaration2.getName();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"declaration.name ?: return null");
        String name2 = string;
        PsiFile psiFile = declaration2.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"declaration.containingFile");
        PsiDirectory expectedDir = psiFile.getContainingDirectory();
        PsiPackage expectedPackage = JavaDirectoryService.getInstance().getPackage(expectedDir);
        Object object = expectedPackage;
        if (object == null || (object = object.getQualifiedName()) == null) {
            object = "";
        }
        PsiDirectory psiDirectory = PackageUtilsKt.findOrCreateDirectoryForPackage(this.actualModule, (String)object);
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory actualDirectory = psiDirectory;
        return (KtFile)ApplicationUtilsKt.runWriteAction((Function0)new Function0<KtFile>(name2, actualDirectory, declaration2){
            final /* synthetic */ String $name;
            final /* synthetic */ PsiDirectory $actualDirectory;
            final /* synthetic */ KtNamedDeclaration $declaration;

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final KtFile invoke() {
                KtFile ktFile;
                String packageName;
                String string;
                KtPackageDirective packageDirective;
                String fileName = this.$name + ".kt";
                PsiFile existingFile = this.$actualDirectory.findFile(fileName);
                KtPackageDirective ktPackageDirective = packageDirective = this.$declaration.getContainingKtFile().getPackageDirective();
                if ((ktPackageDirective != null ? ktPackageDirective.getPackageNameExpression() : null) == null) {
                    PsiPackage psiPackage = PackageUtilsKt.getPackage(this.$actualDirectory);
                    string = psiPackage != null ? psiPackage.getQualifiedName() : null;
                } else {
                    string = packageName = packageDirective.getFqName().asString();
                }
                if (!(existingFile instanceof KtFile)) {
                    ktFile = KotlinRefactoringUtilKt.createKotlinFile(fileName, this.$actualDirectory, packageName);
                    return ktFile;
                }
                KtPackageDirective existingPackageDirective = ((KtFile)existingFile).getPackageDirective();
                Collection collection = ((KtFile)existingFile).getDeclarations();
                if (!collection.isEmpty()) {
                    KtPackageDirective ktPackageDirective2 = existingPackageDirective;
                    KtPackageDirective ktPackageDirective3 = packageDirective;
                    if (Intrinsics.areEqual((Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null), (Object)(ktPackageDirective3 != null ? ktPackageDirective3.getFqName() : null)) ^ true) {
                        String newName2 = KotlinNameSuggester.INSTANCE.suggestNameByName(this.$name, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(this){
                            final /* synthetic */ getOrCreateImplementationFile.1 this$0;

                            public final boolean invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.this$0.$actualDirectory.findFile(it + ".kt") == null;
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        })) + ".kt";
                        ktFile = KotlinRefactoringUtilKt.createKotlinFile(newName2, this.$actualDirectory, packageName);
                        return ktFile;
                    }
                }
                ktFile = (KtFile)existingFile;
                return ktFile;
            }
            {
                this.$name = string;
                this.$actualDirectory = psiDirectory;
                this.$declaration = ktNamedDeclaration;
                super(0);
            }
        });
    }

    private CreateActualFix(D declaration2, Module actualModule, MultiTargetPlatform.Specific actualPlatform, Function3<? super KtPsiFactory, ? super Project, ? super D, ? extends D> generateIt) {
        super((PsiElement)declaration2);
        this.actualModule = actualModule;
        this.actualPlatform = actualPlatform;
        this.generateIt = generateIt;
    }

    public /* synthetic */ CreateActualFix(@NotNull KtNamedDeclaration declaration2, @NotNull Module actualModule, @NotNull MultiTargetPlatform.Specific actualPlatform, @NotNull Function3 generateIt, DefaultConstructorMarker $constructor_marker) {
        this(declaration2, actualModule, actualPlatform, generateIt);
    }

    @NotNull
    public static final /* synthetic */ Function3 access$getGenerateIt$p(CreateActualFix $this) {
        return $this.generateIt;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            ModuleSourceInfo moduleSourceInfo;
            Map compatibility;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = DiagnosticFactory.cast(diagnostic, Errors.NO_ACTUAL_FOR_EXPECT);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"DiagnosticFactory.cast(d\u2026ors.NO_ACTUAL_FOR_EXPECT)");
            DiagnosticWithParameters3 d2 = (DiagnosticWithParameters3)d;
            Object e = d2.getPsiElement();
            if (!(e instanceof KtNamedDeclaration)) {
                e = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)e;
            if (ktNamedDeclaration == null) {
                return null;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            Object c = d2.getC();
            Intrinsics.checkExpressionValueIsNotNull(c, (String)"d.c");
            Map map2 = compatibility = (Map)c;
            if (!map2.isEmpty() && !(declaration2 instanceof KtFunction)) {
                return null;
            }
            Object b = d2.getB();
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"d.b");
            ModuleDescriptor actualModuleDescriptor = (ModuleDescriptor)b;
            ModuleInfo moduleInfo2 = actualModuleDescriptor.getCapability(ModuleInfo.Companion.getCapability());
            if (!(moduleInfo2 instanceof ModuleSourceInfo)) {
                moduleInfo2 = null;
            }
            if ((moduleSourceInfo = (ModuleSourceInfo)moduleInfo2) == null || (moduleSourceInfo = moduleSourceInfo.getModule()) == null) {
                return null;
            }
            ModuleSourceInfo actualModule = moduleSourceInfo;
            MultiTargetPlatform multiTargetPlatform = MultiTargetPlatformKt.getMultiTargetPlatform(actualModuleDescriptor);
            if (!(multiTargetPlatform instanceof MultiTargetPlatform.Specific)) {
                multiTargetPlatform = null;
            }
            MultiTargetPlatform.Specific specific = (MultiTargetPlatform.Specific)multiTargetPlatform;
            if (specific == null) {
                return null;
            }
            MultiTargetPlatform.Specific actualPlatform = specific;
            KtNamedDeclaration ktNamedDeclaration2 = declaration2;
            return ktNamedDeclaration2 instanceof KtClassOrObject ? (IntentionAction)new CreateActualClassFix((KtClassOrObject)declaration2, (Module)actualModule, actualPlatform) : (ktNamedDeclaration2 instanceof KtFunction ? (IntentionAction)new CreateActualFunctionFix((KtFunction)declaration2, (Module)actualModule, actualPlatform) : (ktNamedDeclaration2 instanceof KtProperty ? (IntentionAction)new CreateActualPropertyFix((KtProperty)declaration2, (Module)actualModule, actualPlatform) : null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

