/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.library;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.library.KonanLibrary;
import org.jetbrains.kotlin.konan.library.MetadataReader;
import org.jetbrains.kotlin.konan.library.SearchPathResolverWithTarget;
import org.jetbrains.kotlin.konan.library.impl.DefaultMetadataReaderImpl;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryImpl;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryLayoutImplKt;
import org.jetbrains.kotlin.konan.library.resolver.KonanLibraryResolver;
import org.jetbrains.kotlin.konan.library.resolver.impl.KonanLibraryResolverImpl;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u00a8\u0006\u0013"}, d2={"createKonanLibrary", "Lorg/jetbrains/kotlin/konan/library/KonanLibrary;", "libraryFile", "Lorg/jetbrains/kotlin/konan/file/File;", "currentAbiVersion", "", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "isDefault", "", "metadataReader", "Lorg/jetbrains/kotlin/konan/library/MetadataReader;", "libraryResolver", "Lorg/jetbrains/kotlin/konan/library/resolver/KonanLibraryResolver;", "Lorg/jetbrains/kotlin/konan/library/SearchPathResolverWithTarget;", "abiVersion", "unpackZippedKonanLibraryTo", "", "newDir", "kotlin-native-library-reader"})
public final class KonanLibraryUtilsKt {
    public static final void unpackZippedKonanLibraryTo(@NotNull File $receiver, @NotNull File newDir) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)newDir, (String)"newDir");
        KonanLibraryLayoutImplKt.zippedKonanLibraryChecks($receiver);
        if (newDir.getExists()) {
            if (newDir.isDirectory()) {
                newDir.deleteRecursively();
            } else {
                newDir.delete();
            }
        }
        ZipUtilKt.withMutableZipFileSystem($receiver, (Function1)new Function1<FileSystem, Unit>(newDir){
            final /* synthetic */ File $newDir;

            public final void invoke(@NotNull FileSystem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ZipUtilKt.file(it, "/").recursiveCopyTo(this.$newDir);
            }
            {
                this.$newDir = file;
                super(1);
            }
        });
        boolean bl = newDir.getExists();
        if (!bl) {
            String string = "Could not unpack " + $receiver + " as " + newDir + '.';
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public static final KonanLibrary createKonanLibrary(@NotNull File libraryFile, int currentAbiVersion, @Nullable KonanTarget target, boolean isDefault, @NotNull MetadataReader metadataReader) {
        Intrinsics.checkParameterIsNotNull((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkParameterIsNotNull((Object)metadataReader, (String)"metadataReader");
        return new KonanLibraryImpl(libraryFile, currentAbiVersion, target, isDefault, metadataReader);
    }

    @NotNull
    public static /* synthetic */ KonanLibrary createKonanLibrary$default(File file, int n, KonanTarget konanTarget, boolean bl, MetadataReader metadataReader, int n2, Object object) {
        if ((n2 & 4) != 0) {
            konanTarget = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            metadataReader = DefaultMetadataReaderImpl.INSTANCE;
        }
        return KonanLibraryUtilsKt.createKonanLibrary(file, n, konanTarget, bl, metadataReader);
    }

    @NotNull
    public static final KonanLibraryResolver libraryResolver(@NotNull SearchPathResolverWithTarget $receiver, int abiVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return new KonanLibraryResolverImpl($receiver, abiVersion);
    }
}

