/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.Layerer;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCommonExtras<T>
extends DiagramExtras<T> {
    public static final DiagramCategory BORDERS = new DiagramCategory("Borderless View", AllIcons.Graph.SnapToGrid, false, false, false);

    @NotNull
    public JComponent createLabelNode(DiagramNode<T> node, DiagramBuilder builder, JPanel wrapper) {
        this.setNodeBorders(wrapper, builder.getPresentation().isCategoryEnabled(BORDERS));
        SimpleColoredComponent label = this.createLabel(builder, node);
        this.setColors(label);
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            SpringCommonExtras.$$$reportNull$$$0(0);
        }
        return simpleColoredComponent;
    }

    @Nullable
    public Layouter getCustomLayouter(GraphSettings settings, Project project) {
        HierarchicGroupLayouter layouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        layouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.LEFT_TO_RIGHT));
        layouter.setMinimalNodeDistance(40.0);
        layouter.setMinimalLayerDistance(80.0);
        layouter.setLayerer((Layerer)GraphManager.getGraphManager().createBFSLayerer());
        return layouter;
    }

    @NotNull
    public SimpleColoredComponent createLabel(DiagramBuilder builder, DiagramNode<T> node) {
        SimpleColoredComponent label = new SimpleColoredComponent();
        DiagramElementManager manager = builder.getProvider().getElementManager();
        String presentableName = manager.getElementTitle(node.getIdentifyingElement());
        if (presentableName != null) {
            if (GraphViewUtil.isPrintMode()) {
                label.append(presentableName, new SimpleTextAttributes(0, (Color)JBColor.BLACK));
            } else {
                label.append(presentableName, new SimpleTextAttributes(0, null));
            }
        }
        label.setIcon(node.getIcon());
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            SpringCommonExtras.$$$reportNull$$$0(1);
        }
        return simpleColoredComponent;
    }

    public void setColors(SimpleColoredComponent label) {
        if (GraphViewUtil.isPrintMode()) {
            label.setForeground((Color)JBColor.BLACK);
        }
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setForeground(JBColor.foreground());
    }

    protected void setNodeBorders(JPanel wrapper, boolean showBorders) {
        wrapper.setBorder(showBorders ? this.getNodeBorder() : JBUI.Borders.empty());
        Container outerPanel = wrapper.getParent();
        if (outerPanel instanceof JPanel) {
            ((JPanel)outerPanel).setBorder(null);
        }
        wrapper.setBackground(JBColor.background());
    }

    @NotNull
    protected Border getNodeBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        if (jBEmptyBorder == null) {
            SpringCommonExtras.$$$reportNull$$$0(2);
        }
        return jBEmptyBorder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/perspectives/diagrams/SpringCommonExtras";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBorder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

