/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.toclasschain;

import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.externalizable.toclasschain.ToClassExternalizer;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.TapestryParameter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.chain.Context;

public class ComponentExternalizer
extends ToClassExternalizer {
    @Override
    public boolean execute(Context context) throws Exception {
        if (!super.execute(context)) {
            return false;
        }
        if (!(this.getContext().getElement() instanceof Component)) {
            return false;
        }
        Component component = (Component)this.getContext().getElement();
        IJavaField field = component.getProject().getJavaTypeCreator().createField(component.getElementClass().getName(), component.getElementClass(), true, true);
        String suggestedFieldName = this.suggestName(field.getName(), new ArrayList<String>(this.getContext().getTargetClass().getFields(false).keySet()));
        if (!suggestedFieldName.equals(field.getName())) {
            field = component.getProject().getJavaTypeCreator().createField(suggestedFieldName, component.getElementClass(), true, true);
        }
        HashMap<String, String> annotationParameters = new HashMap<String, String>();
        StringBuilder parametersParameter = new StringBuilder("{");
        for (TapestryParameter parameter : component.getParameters().values()) {
            if (!parameter.isRequired()) continue;
            parametersParameter.append("\"").append(parameter.getName()).append("=\",");
        }
        if (parametersParameter.length() > 1) {
            parametersParameter.deleteCharAt(parametersParameter.length() - 1);
            parametersParameter.append("}");
            annotationParameters.put("parameters", parametersParameter.toString());
        }
        component.getProject().getJavaTypeCreator().createFieldAnnotation(field, "org.apache.tapestry5.annotations.Component", annotationParameters);
        String serialized = field.getStringRepresentation();
        if (component.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), component.getElementClass())) {
            serialized = serialized.replace(component.getElementClass().getFullyQualifiedName(), component.getElementClass().getName());
        }
        if (component.getProject().getJavaTypeCreator().ensureClassImport(this.getContext().getTargetClass(), component.getProject().getJavaTypeFinder().findType("org.apache.tapestry5.annotations.Component", true))) {
            serialized = serialized.replace("org.apache.tapestry5.annotations.Component", "Component");
        }
        this.getContext().setResult("\n" + serialized + "\n");
        return true;
    }
}

