/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation;

import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.externalizable.ExternalizableToTemplate;
import com.intellij.tapestry.core.model.externalizable.totemplatechain.ExternalizeToTemplateChain;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.core.util.PathUtils;
import java.util.ArrayList;
import java.util.Collection;

public class Page
extends PresentationLibraryElement
implements ExternalizableToTemplate {
    private IResource[] _templateCache;

    Page(Library library, IJavaClassType pageClass, TapestryProject project) throws NotTapestryElementException {
        super(library, pageClass, project);
    }

    @Override
    public boolean allowsTemplate() {
        return true;
    }

    @Override
    public IResource[] getTemplate() {
        if (this._templateCache != null && Page.checkAllValidResources(this._templateCache)) {
            return this._templateCache;
        }
        ArrayList<IResource> templates = new ArrayList<IResource>();
        String packageName = this.getElementClass().getFullyQualifiedName().substring(0, this.getElementClass().getFullyQualifiedName().lastIndexOf(46));
        Collection<IResource> resources = this.getProject().getResourceFinder().findLocalizedClasspathResource(PathUtils.packageIntoPath(packageName, true) + PathUtils.getLastPathElement(this.getName()) + "." + "tml", true);
        if (resources.size() > 0) {
            for (IResource template : resources) {
                templates.add(template);
            }
        }
        if ((resources = this.getProject().getResourceFinder().findLocalizedContextResource(this.getName() + "." + "tml")).size() > 0) {
            for (IResource template : resources) {
                templates.add(template);
            }
        }
        this._templateCache = templates.toArray(IResource.EMPTY_ARRAY);
        return this._templateCache;
    }

    @Override
    public String getTemplateRepresentation(String namespacePrefix) throws Exception {
        return ExternalizeToTemplateChain.getInstance().externalize(this, namespacePrefix);
    }
}

