/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.tapestry.core.java.IJavaAnnotation;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.core.java.IMethodParameter;
import com.intellij.tapestry.intellij.core.java.IntellijJavaAnnotation;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijMethodParameter;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import java.util.ArrayList;
import java.util.Collection;

public class IntellijJavaMethod
implements IJavaMethod {
    private final Module _module;
    private final PsiMethod _psiMethod;

    public IntellijJavaMethod(Module module, PsiMethod psiMethod) {
        this._module = module;
        this._psiMethod = psiMethod;
    }

    @Override
    public String getName() {
        return this._psiMethod.getName();
    }

    @Override
    public IJavaType getReturnType() {
        return IdeaUtils.createJavaTypeFromPsiType(this._module, this._psiMethod.getReturnType());
    }

    @Override
    public Collection<IMethodParameter> getParameters() {
        ArrayList<IMethodParameter> parameters = new ArrayList<IMethodParameter>();
        for (PsiParameter parameter : this._psiMethod.getParameterList().getParameters()) {
            parameters.add(new IntellijMethodParameter(this._module, parameter));
        }
        return parameters;
    }

    @Override
    public Collection<IJavaAnnotation> getAnnotations() {
        ArrayList<IJavaAnnotation> annotations = new ArrayList<IJavaAnnotation>();
        for (PsiAnnotation annotation : this._psiMethod.getModifierList().getAnnotations()) {
            annotations.add(new IntellijJavaAnnotation(annotation));
        }
        return annotations;
    }

    @Override
    public IJavaAnnotation getAnnotation(String annotationQualifiedName) {
        for (IJavaAnnotation annotation : this.getAnnotations()) {
            if (!annotation.getFullyQualifiedName().equals(annotationQualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public IJavaClassType getContainingClass() {
        return new IntellijJavaClassType(this._module, this._psiMethod.getContainingClass().getContainingFile());
    }

    @Override
    public String getDocumentation() {
        StringBuilder description = new StringBuilder();
        PsiDocComment document = this._psiMethod.getDocComment();
        if (document == null) {
            document = ((PsiMethod)this._psiMethod.getNavigationElement()).getDocComment();
        }
        if (document != null) {
            for (PsiElement comment : document.getDescriptionElements()) {
                if (comment instanceof PsiWhiteSpace) continue;
                description.append(comment.getText());
            }
        }
        return description.toString();
    }

    public PsiMethod getPsiMethod() {
        return this._psiMethod;
    }
}

