/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.java;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tapestry.core.ioc.IServiceBindingDiscoverer;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaTypeFinder;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijJavaTypeFinder
implements IJavaTypeFinder {
    private final Module _module;

    public IntellijJavaTypeFinder(@NotNull Module module) {
        if (module == null) {
            IntellijJavaTypeFinder.$$$reportNull$$$0(0);
        }
        this._module = module;
    }

    @Override
    @Nullable
    public IJavaClassType findType(@NotNull String fullyQualifiedName, boolean includeDependencies) {
        PsiClass psiClass;
        if (fullyQualifiedName == null) {
            IntellijJavaTypeFinder.$$$reportNull$$$0(1);
        }
        return (psiClass = JavaPsiFacade.getInstance((Project)this._module.getProject()).findClass(fullyQualifiedName, this.getScope(includeDependencies))) != null ? new IntellijJavaClassType(this._module, psiClass.getContainingFile()) : null;
    }

    private GlobalSearchScope getScope(boolean includeDependencies) {
        return includeDependencies ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this._module, (boolean)false) : GlobalSearchScope.moduleScope((Module)this._module);
    }

    @Override
    public Collection<IJavaClassType> findTypesInPackage(String packageName, boolean includeDependencies) {
        PsiClass[] classes;
        ArrayList<IJavaClassType> types = new ArrayList<IJavaClassType>();
        for (PsiClass clazz : classes = this.findPackage(packageName).getClasses(this.getScope(includeDependencies))) {
            types.add(new IntellijJavaClassType(this._module, clazz.getContainingFile()));
        }
        return types;
    }

    @Override
    public Collection<IJavaClassType> findTypesInPackageRecursively(String basePackageName, boolean includeDependencies) {
        ArrayList<IJavaClassType> types = new ArrayList<IJavaClassType>();
        PsiPackage psiPackage = this.findPackage(basePackageName);
        if (psiPackage != null) {
            for (PsiClass psiClass : this.findPackage(basePackageName).getClasses(this.getScope(includeDependencies))) {
                types.add(new IntellijJavaClassType(this._module, psiClass.getContainingFile()));
            }
            for (PsiClass psiClass : this.findPackage(basePackageName).getSubPackages(this.getScope(includeDependencies))) {
                types.addAll(this.findTypesInPackageRecursively(psiClass.getQualifiedName(), includeDependencies));
            }
        }
        return types;
    }

    private PsiPackage findPackage(String basePackageName) {
        return JavaPsiFacade.getInstance((Project)this._module.getProject()).findPackage(basePackageName);
    }

    @Override
    public IServiceBindingDiscoverer getServiceBindingDiscoverer() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tapestry/intellij/core/java/IntellijJavaTypeFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

