/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.core.resource;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.resource.CoreXmlRecursiveElementVisitor;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.core.resource.xml.IntellijXmlTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class IntellijResource
implements IResource {
    private final PsiFile _psiFile;

    public IntellijResource(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            IntellijResource.$$$reportNull$$$0(0);
        }
        this._psiFile = psiFile;
    }

    @Override
    public String getName() {
        return this._psiFile.getName();
    }

    @Override
    public File getFile() {
        VirtualFile virtualFile = this._psiFile.getViewProvider().getVirtualFile();
        return new File(virtualFile.getPath());
    }

    public PsiFile getPsiFile() {
        return this._psiFile;
    }

    @Override
    public String getExtension() {
        return this._psiFile.getVirtualFile().getExtension();
    }

    @Override
    public void accept(final CoreXmlRecursiveElementVisitor visitor) {
        this._psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                visitor.visitTag(new IntellijXmlTag(tag));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/tapestry/intellij/core/resource/IntellijResource", "<init>"));
    }
}

