/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.facet.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.tapestry.intellij.facet.AddTapestrySupportUtil;
import com.intellij.tapestry.intellij.facet.TapestryFacet;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import com.intellij.tapestry.intellij.facet.TapestryVersion;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FacetEditor
extends FacetEditorTab {
    private JPanel _mainPanel;
    private JTextField _filterName;
    private JTextField _applicationPackage;
    private JPanel _descriptionPanel;
    private final TapestryFacetConfiguration _configuration;

    public FacetEditor(TapestryFacet facet, TapestryFacetConfiguration configuration) {
        this._configuration = configuration;
        this.$$$setupUI$$$();
        if (this._configuration.getFilterName() == null) {
            this._configuration.setFilterName(facet.getModule().getName().toLowerCase());
        }
        this._filterName.setText(this._configuration.getFilterName());
        this._applicationPackage.setText(this._configuration.getApplicationPackage());
    }

    @Nls
    public String getDisplayName() {
        return "Tapestry";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this._mainPanel;
        if (jPanel == null) {
            FacetEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            FacetEditor.$$$reportNull$$$0(1);
        }
        if (this._configuration.getVersion() == null) {
            this._configuration.setVersion(TapestryVersion.TAPESTRY_5_3_6);
        }
        AddTapestrySupportUtil.addSupportInWriteCommandAction(facet.getModule(), this._configuration, false, false);
    }

    public boolean isModified() {
        return !this._filterName.getText().equals(this._configuration.getFilterName()) || !this._applicationPackage.getText().equals(this._configuration.getApplicationPackage());
    }

    public void apply() {
        this._configuration.setFilterName(this._filterName.getText());
        this._configuration.setApplicationPackage(this._applicationPackage.getText());
    }

    public void reset() {
        this._filterName.setText(this._configuration.getFilterName());
        this._applicationPackage.setText(this._configuration.getApplicationPackage());
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this._descriptionPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this._descriptionPanel.add(new JLabel("<html>Tapestry is an open-source framework for creating dynamic, robust, highly scalable web applications in Java.</html>"));
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("More about Tapestry");
        hyperlinkLabel.setHyperlinkTarget("http://tapestry.apache.org");
        this._descriptionPanel.add((Component)hyperlinkLabel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/intellij/facet/ui/FacetEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/intellij/facet/ui/FacetEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onFacetInitialized";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this._mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this._descriptionPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Application Configuration", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Filter Name");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Application Package");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this._filterName = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this._applicationPackage = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._mainPanel;
    }
}

