/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.lang.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.lang.descriptor.BasicTapestryTagDescriptor;
import com.intellij.tapestry.intellij.lang.descriptor.DescriptorUtil;
import com.intellij.tapestry.intellij.lang.descriptor.TapestryNamespaceDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryTagDescriptor
extends BasicTapestryTagDescriptor {
    private final PresentationLibraryElement myComponent;
    private final List<Mixin> myMixins;

    public TapestryTagDescriptor(@NotNull PresentationLibraryElement component, @Nullable String prefix, TapestryNamespaceDescriptor descriptor) {
        if (component == null) {
            TapestryTagDescriptor.$$$reportNull$$$0(0);
        }
        this(component, Collections.emptyList(), prefix, descriptor);
    }

    public TapestryTagDescriptor(@NotNull PresentationLibraryElement component, List<Mixin> mixins, @Nullable String namespacePrefix, TapestryNamespaceDescriptor descriptor) {
        if (component == null) {
            TapestryTagDescriptor.$$$reportNull$$$0(1);
        }
        super(namespacePrefix, descriptor);
        this.myComponent = component;
        this.myMixins = mixins;
    }

    public String getDefaultName() {
        Library library = this.myComponent.getLibrary();
        String name = this.myComponent.getName().toLowerCase().replace('/', '.');
        if (library != null && library.getShortName() != null) {
            name = library.getShortName() + '.' + name;
        }
        return this.getPrefixWithColon() + name;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return context != null ? DescriptorUtil.getAttributeDescriptors(context) : this.getAttributeDescriptors();
    }

    private XmlAttributeDescriptor[] getAttributeDescriptors() {
        ArrayList result = new ArrayList();
        ContainerUtil.addAll(result, (Object[])DescriptorUtil.getAttributeDescriptors((Component)this.myComponent, null));
        for (Mixin mixin : this.myMixins) {
            ContainerUtil.addAll(result, (Object[])DescriptorUtil.getAttributeDescriptors(mixin, null));
        }
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        return context != null ? DescriptorUtil.getAttributeDescriptor(attributeName, context) : DescriptorUtil.getAttributeDescriptor(attributeName, (Component)this.myComponent, this.myMixins);
    }

    @Override
    public PsiElement getDeclaration() {
        return ((IntellijJavaClassType)this.myComponent.getElementClass()).getPsiClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/tapestry/intellij/lang/descriptor/TapestryTagDescriptor", "<init>"));
    }
}

