/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow.nodes;

import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.TemplateElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedComponentNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class EmbeddedTemplateNode
extends DefaultMutableTreeNode {
    private transient IResource _resource;
    private final List<InjectedElement> _embeddedTemplateNodes = new ArrayList<InjectedElement>();

    public EmbeddedTemplateNode(IResource resource, PresentationLibraryElement element) {
        super(resource);
        this._resource = resource;
        if (element.getElementClass().getFile() == null) {
            return;
        }
        switch (element.getElementType()) {
            case COMPONENT: {
                this.addChildElements((Component)element, resource.getName());
                break;
            }
            case PAGE: {
                this.addChildElements((Page)element, resource.getName());
                break;
            }
            case MIXIN: {
                this.addChildElements((Mixin)element, resource.getName());
            }
        }
    }

    private void addChildElements(Component component, String resource) {
        for (TemplateElement embedded : component.getEmbeddedComponentsTemplate()) {
            if (!embedded.getTemplate().equals(resource)) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedTemplateNodes.add(embedded.getElement());
        }
    }

    private void addChildElements(Page page, String resource) {
        for (TemplateElement embedded : page.getEmbeddedComponentsTemplate()) {
            if (!embedded.getTemplate().equals(resource)) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedTemplateNodes.add(embedded.getElement());
        }
    }

    private void addChildElements(Mixin mixin, String resource) {
        for (TemplateElement embedded : mixin.getEmbeddedComponentsTemplate()) {
            if (!embedded.getTemplate().equals(resource)) continue;
            this.add(new EmbeddedComponentNode(embedded.getElement()));
            this._embeddedTemplateNodes.add(embedded.getElement());
        }
    }

    public List<InjectedElement> getEmbeddedTemplateNodes() {
        return this._embeddedTemplateNodes;
    }

    @Override
    public String toString() {
        return this._resource.getName().split("." + this._resource.getExtension())[0];
    }
}

