/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow.nodes;

import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.toolwindow.nodes.InjectedPageNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class InjectedPagesNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1083245064296005063L;
    private final List<InjectedElement> _injectedComponentNodes = new ArrayList<InjectedElement>();

    public InjectedPagesNode(Object userObject) {
        super(userObject);
        PresentationLibraryElement element = (PresentationLibraryElement)userObject;
        if (element.getElementClass().getFile() == null) {
            return;
        }
        switch (element.getElementType()) {
            case COMPONENT: {
                this.addChildElements((Component)userObject);
                break;
            }
            case PAGE: {
                this.addChildElements((Page)userObject);
                break;
            }
            case MIXIN: {
                this.addChildElements((Mixin)userObject);
            }
        }
    }

    private void addChildElements(Component component) {
        for (InjectedElement injected : component.getInjectedPages()) {
            this.add(new InjectedPageNode(injected));
            this._injectedComponentNodes.add(injected);
        }
    }

    private void addChildElements(Page page) {
        for (InjectedElement injected : page.getInjectedPages()) {
            this.add(new InjectedPageNode(injected));
            this._injectedComponentNodes.add(injected);
        }
    }

    private void addChildElements(Mixin mixin) {
        for (InjectedElement injected : mixin.getInjectedPages()) {
            this.add(new InjectedPageNode(injected));
            this._injectedComponentNodes.add(injected);
        }
    }

    public List<InjectedElement> getInjectedComponentNodes() {
        return this._injectedComponentNodes;
    }

    @Override
    public String toString() {
        return "Injected Pages";
    }
}

