/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view;

import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.tapestry.core.exceptions.NotTapestryElementException;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.intellij.view.TapestryProjectViewPane;
import com.intellij.tapestry.intellij.view.nodes.ComponentNode;
import com.intellij.tapestry.intellij.view.nodes.MixinNode;
import com.intellij.tapestry.intellij.view.nodes.PageNode;
import com.intellij.tapestry.lang.TmlFileType;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

class ViewMouseListener
extends MouseInputAdapter {
    private MouseEvent _firstMouseEvent = null;
    private final TapestryProjectViewPane _tapestryProjectViewPane;

    ViewMouseListener(TapestryProjectViewPane tapestryProjectViewPane) {
        this._tapestryProjectViewPane = tapestryProjectViewPane;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this._tapestryProjectViewPane.getTree().getSelectionPath() != null && this._tapestryProjectViewPane.getTree().getSelectionPaths().length < 2) {
            Object selectedNode = ((DefaultMutableTreeNode)this._tapestryProjectViewPane.getTree().getSelectionPath().getLastPathComponent()).getUserObject();
            Module module = (Module)this._tapestryProjectViewPane.getData(DataKeys.MODULE.getName());
            if (!(selectedNode instanceof PageNode || selectedNode instanceof ComponentNode || selectedNode instanceof MixinNode)) {
                return;
            }
            if (FileEditorManager.getInstance((Project)this._tapestryProjectViewPane.getProject()).getSelectedFiles().length == 0) {
                return;
            }
            PsiFile fileInEditor = PsiManager.getInstance((Project)this._tapestryProjectViewPane.getProject()).findFile(FileDocumentManager.getInstance().getFile(FileEditorManager.getInstance((Project)this._tapestryProjectViewPane.getProject()).getSelectedTextEditor().getDocument()));
            FileType typeFileInEditor = fileInEditor.getFileType();
            if (!(fileInEditor instanceof PsiClassOwner) && !typeFileInEditor.equals((Object)TmlFileType.INSTANCE)) {
                return;
            }
            Module moduleForFile = ProjectRootManager.getInstance((Project)this._tapestryProjectViewPane.getProject()).getFileIndex().getModuleForFile(fileInEditor.getVirtualFile());
            if (!fileInEditor.isWritable() || moduleForFile == null || !moduleForFile.getModuleFilePath().equals(module.getModuleFilePath())) {
                return;
            }
            if (typeFileInEditor.equals((Object)TmlFileType.INSTANCE)) {
                if (TapestryUtils.getTapestryNamespacePrefix((XmlFile)fileInEditor) == null) {
                    return;
                }
                if (selectedNode instanceof MixinNode) {
                    return;
                }
            }
            if (fileInEditor instanceof PsiClassOwner) {
                PresentationLibraryElement presentationLibraryElement;
                PsiClass psiClass = IdeaUtils.findPublicClass(fileInEditor);
                if (psiClass == null) {
                    return;
                }
                IntellijJavaClassType elementClass = new IntellijJavaClassType(module, psiClass.getContainingFile());
                try {
                    presentationLibraryElement = PresentationLibraryElement.createProjectElementInstance(elementClass, TapestryModuleSupportLoader.getTapestryProject(module));
                }
                catch (NotTapestryElementException e) {
                    return;
                }
                if (presentationLibraryElement.getElementType().equals((Object)PresentationLibraryElement.ElementType.PAGE) && !(selectedNode instanceof PageNode) && !(selectedNode instanceof ComponentNode)) {
                    return;
                }
                if (presentationLibraryElement.getElementType().equals((Object)PresentationLibraryElement.ElementType.COMPONENT) && !(selectedNode instanceof PageNode) && !(selectedNode instanceof ComponentNode) && !(selectedNode instanceof MixinNode)) {
                    return;
                }
                if (presentationLibraryElement.getElementType().equals((Object)PresentationLibraryElement.ElementType.MIXIN) && !(selectedNode instanceof PageNode)) {
                    return;
                }
            }
            this._firstMouseEvent = event;
            event.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this._firstMouseEvent != null) {
            event.consume();
            int dx = Math.abs(event.getX() - this._firstMouseEvent.getX());
            int dy = Math.abs(event.getY() - this._firstMouseEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent component = (JComponent)event.getSource();
                TransferHandler handler = component.getTransferHandler();
                handler.exportAsDrag(component, this._firstMouseEvent, 1);
                this._firstMouseEvent = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this._firstMouseEvent = null;
    }
}

