/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view.nodes;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.util.PathUtils;
import com.intellij.tapestry.intellij.view.nodes.FolderNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNodesComparator;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPresentationNode
extends TapestryNode {
    public AbstractPresentationNode(Module module, AbstractTreeBuilder treeBuilder) {
        super(module, treeBuilder);
    }

    @Override
    @NotNull
    public SimpleNode[] getChildren() {
        TreeSet<TapestryNode> children = new TreeSet<TapestryNode>(PackageNodesComparator.getInstance());
        ArrayList<String> addedFolders = new ArrayList<String>();
        for (PresentationLibraryElement element : this.getChildElements()) {
            if (element.getName().contains("/")) {
                String folderName = PathUtils.getFirstPathElement(element.getName());
                if (addedFolders.contains(folderName)) continue;
                children.add(new FolderNode(folderName, (Library)this.getElement(), this.getChildNodeClass(), this._module, this._treeBuilder));
                addedFolders.add(folderName);
                continue;
            }
            children.add(this.newChildNode(element, this._module, this._treeBuilder));
        }
        SimpleNode[] simpleNodeArray = children.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            AbstractPresentationNode.$$$reportNull$$$0(0);
        }
        return simpleNodeArray;
    }

    protected abstract TapestryNode newChildNode(PresentationLibraryElement var1, Module var2, AbstractTreeBuilder var3);

    protected abstract Collection<PresentationLibraryElement> getChildElements();

    protected abstract Class getChildNodeClass();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/view/nodes/AbstractPresentationNode", "getChildren"));
    }
}

