/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.view.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.intellij.view.nodes.ComponentsNode;
import com.intellij.tapestry.intellij.view.nodes.MixinsNode;
import com.intellij.tapestry.intellij.view.nodes.PackageNode;
import com.intellij.tapestry.intellij.view.nodes.PagesNode;
import com.intellij.tapestry.intellij.view.nodes.TapestryNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ExternalLibraryNode
extends TapestryNode {
    public ExternalLibraryNode(Library library, Module module, AbstractTreeBuilder treeBuilder) {
        super(module, treeBuilder);
        this.init(library, (ItemPresentation)new PresentationData(library.getId(), library.getId(), AllIcons.Modules.Library, null));
    }

    @Override
    @NotNull
    public SimpleNode[] getChildren() {
        ArrayList<PackageNode> children = new ArrayList<PackageNode>();
        Library library = (Library)this.getElement();
        if (library.getPages().size() > 0) {
            children.add(new PagesNode(library, JavaPsiFacade.getInstance((Project)this.myProject).findPackage(library.getBasePackage() + "." + "pages").getDirectories(GlobalSearchScope.moduleWithLibrariesScope((Module)this._module))[0], this._module, this._treeBuilder));
        }
        if (library.getComponents().size() > 0) {
            children.add(new ComponentsNode(library, JavaPsiFacade.getInstance((Project)this.myProject).findPackage(library.getBasePackage() + "." + "components").getDirectories(GlobalSearchScope.moduleWithLibrariesScope((Module)this._module))[0], this._module, this._treeBuilder));
        }
        if (library.getMixins().size() > 0) {
            children.add(new MixinsNode(library, JavaPsiFacade.getInstance((Project)this.myProject).findPackage(library.getBasePackage() + "." + "mixins").getDirectories(GlobalSearchScope.moduleWithLibrariesScope((Module)this._module))[0], this._module, this._treeBuilder));
        }
        SimpleNode[] simpleNodeArray = children.toArray(new TapestryNode[0]);
        if (simpleNodeArray == null) {
            ExternalLibraryNode.$$$reportNull$$$0(0);
        }
        return simpleNodeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/intellij/view/nodes/ExternalLibraryNode", "getChildren"));
    }
}

