/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.codeInsight.completion.util.SimpleMethodCallLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.tapestry.TapestryBundle;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.util.TapestryUtils;
import com.intellij.tapestry.lang.TelLanguage;
import com.intellij.tapestry.psi.TapestryAccessorMethod;
import com.intellij.tapestry.psi.TelExpression;
import com.intellij.tapestry.psi.TelMethodCallExpression;
import com.intellij.tapestry.psi.TelPsiUtil;
import com.intellij.tapestry.psi.TelReferenceQualifier;
import com.intellij.tapestry.psi.TelVariantsProcessor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TelQualifiedReference
implements PsiPolyVariantReference {
    private static final ResolveCache.PolyVariantResolver<TelQualifiedReference> MY_RESOLVER = (expression, incompleteCode) -> expression.resolveInner();
    private final TelReferenceQualifier myElement;

    protected TelQualifiedReference(@NotNull TelReferenceQualifier element) {
        if (element == null) {
            TelQualifiedReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @NotNull
    public TelExpression getElement() {
        TelReferenceQualifier telReferenceQualifier = this.myElement;
        if (telReferenceQualifier == null) {
            TelQualifiedReference.$$$reportNull$$$0(1);
        }
        return telReferenceQualifier;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            TelQualifiedReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isSoft() {
        return true;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TelQualifiedReference.$$$reportNull$$$0(3);
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            TelQualifiedReference.$$$reportNull$$$0(4);
        }
        PsiManager manager = this.myElement.getManager();
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement target = result.getElement();
            if (manager.areElementsEquivalent(element, target)) {
                return true;
            }
            if (target instanceof BeanPropertyElement && manager.areElementsEquivalent(element, (PsiElement)((BeanPropertyElement)target).getMethod())) {
                return true;
            }
            if (!(target instanceof TapestryAccessorMethod) || !manager.areElementsEquivalent(element, (PsiElement)((TapestryAccessorMethod)target).getProperty())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
        if (resolveResultArray == null) {
            TelQualifiedReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @Nullable
    public final PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    private ResolveResult[] resolveInner() {
        String referenceName = this.getReferenceName();
        if (referenceName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                TelQualifiedReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        TelVariantsProcessor<ResolveResult> processor = new TelVariantsProcessor<ResolveResult>(this.myElement.getParent(), referenceName, this.getReferenceQualifier() == null){

            @Override
            protected ResolveResult createResult(PsiNamedElement element, boolean validResult) {
                if (element instanceof BeanPropertyElement) {
                    element = ((BeanPropertyElement)element).getMethod();
                }
                return new PsiElementResolveResult((PsiElement)element, validResult);
            }
        };
        this.processVariantsInner(processor, ResolveState.initial());
        ResolveResult[] resolveResultArray = processor.getVariants(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            TelQualifiedReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    private void processVariantsInner(PsiScopeProcessor processor, ResolveState state) {
        PsiElement psiElement;
        PsiClass psiClass;
        TelReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            IntellijJavaClassType intellijJavaClassType = this.getPsiClassTypeForContainingTmlFile();
            if (intellijJavaClassType == null) {
                return;
            }
            PsiClass psiClass2 = intellijJavaClassType.getPsiClass();
            if (psiClass2 == null) {
                return;
            }
            psiClass2.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this.myElement);
            return;
        }
        PsiType type = qualifier.getPsiType();
        if (type instanceof PsiClassType && (psiClass = PsiUtil.resolveClassInType((PsiType)type)) != null && !psiClass.processDeclarations(processor, ResolveState.initial(), null, (PsiElement)this.myElement)) {
            return;
        }
        PsiReference reference = qualifier.getReference();
        if (reference instanceof TelQualifiedReference && (psiElement = reference.resolve()) != null) {
            psiElement.processDeclarations(processor, state, null, (PsiElement)this.myElement);
        }
    }

    @Nullable
    private IntellijJavaClassType getPsiClassTypeForContainingTmlFile() {
        TapestryProject project;
        PsiFile file = this.myElement.getContainingFile();
        if (file.getLanguage() == TelLanguage.INSTANCE) {
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file).getContainingFile();
        }
        if ((project = TapestryUtils.getTapestryProject((PsiElement)file)) == null) {
            return null;
        }
        PresentationLibraryElement libraryElement = project.findElementByTemplate(file);
        if (libraryElement == null) {
            return null;
        }
        return (IntellijJavaClassType)libraryElement.getElementClass();
    }

    @NotNull
    public Object[] getVariants() {
        TelVariantsProcessor<PsiNamedElement> processor = new TelVariantsProcessor<PsiNamedElement>(this.myElement.getParent(), null, this.getReferenceQualifier() == null){

            @Override
            protected PsiNamedElement createResult(PsiNamedElement element, boolean validResult) {
                return element;
            }
        };
        this.processVariantsInner(processor, ResolveState.initial());
        Object[] elements = processor.getVariants(PsiNamedElement.EMPTY_ARRAY);
        Object[] objectArray = ContainerUtil.map2Array((Object[])elements, LookupElement.class, element -> {
            PsiType type;
            if (element instanceof PsiMethod) {
                return new SimpleMethodCallLookupElement((PsiMethod)element);
            }
            String name = element.getName();
            assert (name != null);
            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)element, (String)name);
            lookupElement = lookupElement.withLookupString(name);
            if (element instanceof PsiField) {
                return lookupElement.withTypeText(((PsiField)element).getType().getPresentableText());
            }
            if (element instanceof BeanPropertyElement && (type = ((BeanPropertyElement)element).getPropertyType()) != null) {
                return lookupElement.withTypeText(type.getPresentableText());
            }
            return lookupElement;
        });
        if (objectArray == null) {
            TelQualifiedReference.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    public boolean isQualifierResolved() {
        TelReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiReference reference = qualifier.getReference();
        return reference == null || reference.resolve() != null;
    }

    @Nullable
    public abstract TelReferenceQualifier getReferenceQualifier();

    @Nullable
    public abstract String getReferenceName();

    @Nullable
    public PsiType getPsiType() {
        PsiElement element = this.resolve();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return this.getSubstitutedType(method, method.getReturnType());
        }
        if (element instanceof BeanProperty) {
            BeanProperty beanProperty = (BeanProperty)element;
            return this.getSubstitutedType(beanProperty.getMethod(), beanProperty.getPropertyType());
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getType();
        }
        return null;
    }

    private PsiType getSubstitutedType(PsiMethod method, PsiType result) {
        if (!(result instanceof PsiClassType)) {
            return result;
        }
        PsiClassType resultClassType = (PsiClassType)result;
        PsiType qualifierType = this.getQualifierClassType();
        if (!(qualifierType instanceof PsiClassType)) {
            return result;
        }
        PsiSubstitutor substitutor = TelQualifiedReference.getSuperClassSubstitutor(method.getContainingClass(), (PsiClassType)qualifierType);
        return substitutor.substitute((PsiType)resultClassType);
    }

    @Nullable
    private PsiType getQualifierClassType() {
        TelReferenceQualifier qualifier = this.getReferenceQualifier();
        if (qualifier != null) {
            return qualifier.getPsiType();
        }
        IntellijJavaClassType psiClassType = this.getPsiClassTypeForContainingTmlFile();
        return psiClassType == null ? null : (PsiClassType)psiClassType.getUnderlyingObject();
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClassType classType) {
        if (superClass == null) {
            TelQualifiedReference.$$$reportNull$$$0(9);
        }
        if (classType == null) {
            TelQualifiedReference.$$$reportNull$$$0(10);
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)classResolveResult.getElement(), (PsiSubstitutor)classResolveResult.getSubstitutor());
        if (psiSubstitutor == null) {
            TelQualifiedReference.$$$reportNull$$$0(11);
        }
        return psiSubstitutor;
    }

    public String getUnresolvedMessage(boolean resolvedWithError) {
        String referenceName = this.getReferenceName();
        String typeName = TelPsiUtil.getPresentableText(this.getQualifierClassType());
        PsiElement elementParent = this.myElement.getParent();
        if (!(elementParent instanceof TelMethodCallExpression)) {
            return TapestryBundle.message("error.cannot.resolve.property", referenceName, typeName);
        }
        if (!resolvedWithError) {
            return TapestryBundle.message("error.cannot.resolve.method", referenceName, typeName);
        }
        String argumentTypes = StringUtil.join((Object[])((TelMethodCallExpression)elementParent).getArgumentTypes(), psiType -> TelPsiUtil.getPresentableText(psiType), (String)", ");
        return TapestryBundle.message("error.no.applicable.method", referenceName, typeName, "(" + argumentTypes + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tapestry/psi/TelQualifiedReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tapestry/psi/TelQualifiedReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

