/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.agent.cloud;

import com.cloudbees.api.ApplicationDeployArgs;
import com.cloudbees.api.BeesClient;
import com.intellij.javaee.cloudbees.agent.CBLogPipeBase;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentApplicationImpl;
import com.intellij.javaee.cloudbees.agent.cloud.CBCloudAgentDeploymentConfig;
import com.intellij.remoteServer.agent.util.CloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentDeploymentCallback;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import java.util.Arrays;
import java.util.List;

public class CBCloudAgentDeploymentImpl
implements CloudAgentDeployment {
    private final BeesClient myClient;
    private final CBCloudAgentDeploymentConfig myConfig;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private final LogAgentManager myLogManager;
    private final CloudAgentLogger myLogger;
    private final CBCloudAgentApplicationImpl myApplication;

    public CBCloudAgentDeploymentImpl(BeesClient client, CBCloudAgentDeploymentConfig config, CloudAgentLoggingHandler loggingHandler, LogAgentManager logManager, CloudAgentLogger logger) {
        this.myClient = client;
        this.myConfig = config;
        this.myLoggingHandler = loggingHandler;
        this.myLogManager = logManager;
        this.myLogger = logger;
        this.myApplication = new CBCloudAgentApplicationImpl(client, this.getDeploymentName());
    }

    private String getDeploymentName() {
        return this.myConfig.getDeploymentName();
    }

    public void deploy(CloudAgentDeploymentCallback callback) {
        try {
            ApplicationDeployArgs args = new ApplicationDeployArgs.Builder(this.getDeploymentName()).environment("prod").description("api deployment").deployPackage(this.myConfig.getFile(), this.myConfig.getPackageType()).withParam("containerType", this.myConfig.getContainerType()).build();
            this.myClient.applicationDeployArchive(args);
            this.doStart();
            this.myLogManager.startListeningLog(this.getDeploymentName(), new LogPipeProvider(){

                public List<? extends LogPipe> createLogPipes(String deploymentName) {
                    return Arrays.asList(new CBLogPipe(deploymentName, "server"), new CBLogPipe(deploymentName, "error"));
                }
            });
            callback.succeeded();
        }
        catch (Exception e) {
            callback.errorOccurred(e.toString());
        }
    }

    public void undeploy(CloudAgentDeploymentCallback callback) {
        this.myApplication.undeploy(callback);
    }

    public void doStart() throws Exception {
        this.myClient.applicationStart(this.getDeploymentName());
    }

    private class CBLogPipe
    extends CBLogPipeBase {
        CBLogPipe(String deploymentName, String clientLogKind) {
            super(CBCloudAgentDeploymentImpl.this.myClient, deploymentName, clientLogKind, CBCloudAgentDeploymentImpl.this.myLogger, CBCloudAgentDeploymentImpl.this.myLoggingHandler);
        }
    }
}

