/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.lifecycle.mappings.RequestMappingsEndpoint;
import com.intellij.spring.boot.mvc.lifecycle.mappings.gutter.LiveRequestMappingsNavigationHandler;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class LiveRequestMappingsLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    static final String GUTTER_NAME = "Runtime Request Mappings";
    private static final String CODE_PLACE = "Code";

    public String getId() {
        return "LiveRequestMappingLineMarkerProvider";
    }

    public String getName() {
        return GUTTER_NAME;
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null) {
            return;
        }
        Project project = psiElement.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project) && !SpringGeneralSettings.getInstance((Project)project).isAllowAutoConfigurationMode() || !SpringBootLibraryUtil.hasSpringBootLibrary((Project)project) || !SpringMvcLibraryUtil.hasSpringMvcLibrary((Project)project)) {
            return;
        }
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        if (infos.stream().noneMatch(info -> info.getEndpointData(RequestMappingsEndpoint.getInstance()).getValue() != null)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UIdentifier uIdentifier;
        if (psiElement == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            LiveRequestMappingsLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)psiElement, UIdentifier.class)) == null) {
            return;
        }
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)psiElement);
        if (!(uParent instanceof UMethod)) {
            return;
        }
        UMethod uMethod = (UMethod)uParent;
        PsiMethod psiMethod = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class);
        if (psiMethod == null) {
            return;
        }
        if (psiMethod.isConstructor()) {
            return;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        Project project = psiMethod.getProject();
        List items = ContainerUtil.newSmartList();
        List infos = SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfos();
        for (SpringBootApplicationInfo info : infos) {
            String servletPath;
            String applicationUrl;
            LiveRequestMappingsModel mappingsModel = (LiveRequestMappingsModel)info.getEndpointData(RequestMappingsEndpoint.getInstance()).getValue();
            if (mappingsModel == null || (applicationUrl = (String)info.getApplicationUrl().getValue()) == null) continue;
            SpringBootApplicationServerConfiguration applicationServerConfiguration = (SpringBootApplicationServerConfiguration)info.getServerConfiguration().getValue();
            String string = servletPath = applicationServerConfiguration == null ? null : applicationServerConfiguration.getServletPath();
            List<LiveRequestMapping> mappings = mappingsModel.getRequestMappingsByMethod(psiMethod);
            if (mappings.isEmpty()) continue;
            items.add(new LiveRequestMappingsNavigationHandler.MethodNavigationItem(project, info, applicationUrl, servletPath, mappings, CODE_PLACE));
        }
        if (items.isEmpty()) {
            return;
        }
        LiveRequestMappingsNavigationHandler navigationHandler = new LiveRequestMappingsNavigationHandler(items);
        SpringGutterIconBuilder.CustomNavigationHandlerBuilder builder = SpringGutterIconBuilder.CustomNavigationHandlerBuilder.createBuilder((Icon)AllIcons.RunConfigurations.TestState.Run, (String)navigationHandler.getLiveMarkerInfoTooltipText(), (GutterIconNavigationHandler)navigationHandler, null);
        result.add((RelatedItemLineMarkerInfo)builder.createSpringRelatedMergeableLineMarkerInfo(psiElement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

