/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.impl.internal;

import java.util.Arrays;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;
import org.gradle.internal.impldep.org.sonatype.aether.impl.internal.GraphEdge;

class EdgeStack {
    private GraphEdge[] edges = new GraphEdge[64];
    private int size;

    EdgeStack() {
    }

    public GraphEdge top() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        return this.edges[this.size - 1];
    }

    public void push(GraphEdge edge) {
        if (this.size >= this.edges.length) {
            GraphEdge[] tmp = new GraphEdge[this.size + 64];
            System.arraycopy(this.edges, 0, tmp, 0, this.edges.length);
            this.edges = tmp;
        }
        this.edges[this.size++] = edge;
    }

    public void pop() {
        if (this.size <= 0) {
            throw new IllegalStateException("stack empty");
        }
        --this.size;
    }

    public GraphEdge find(Artifact artifact) {
        GraphEdge edge;
        Dependency dependency;
        for (int i = this.size - 1; i >= 0 && (dependency = (edge = this.edges[i]).getDependency()) != null; --i) {
            Artifact a = dependency.getArtifact();
            if (!a.getArtifactId().equals(artifact.getArtifactId()) || !a.getGroupId().equals(artifact.getGroupId()) || !a.getBaseVersion().equals(artifact.getBaseVersion()) || !a.getExtension().equals(artifact.getExtension()) || !a.getClassifier().equals(artifact.getClassifier())) continue;
            return edge;
        }
        return null;
    }

    public String toString() {
        return Arrays.toString(this.edges);
    }
}

