/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypeSets;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypes;
import com.intellij.plugins.drools.lang.psi.DroolsAttribute;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsLhs;
import com.intellij.plugins.drools.lang.psi.DroolsRhs;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringLiteral;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import icons.DroolsIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DroolsCompletionContributor
extends CompletionContributor {
    private static final Set<String> allowedKeywords = new THashSet<String>(){
        {
            for (IElementType elementType : DroolsTokenTypeSets.KEYWORD_ATTRS.getTypes()) {
                this.add(elementType.toString());
            }
            for (IElementType elementType : DroolsTokenTypeSets.KEYWORDS.getTypes()) {
                this.add(elementType.toString());
            }
        }
    };

    public DroolsCompletionContributor() {
        this.extendRhsStatement();
        this.extendPatternBindExpressions();
        this.extendKeywords();
        this.extendAttributes();
        this.extendDialectAttribute();
        this.extendRule();
    }

    private void extendRule() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsRule"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                DroolsRuleStatement droolsRule;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (droolsRule = (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsRuleStatement.class)) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$2", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement position;
                DroolsRuleStatement droolsRule;
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((droolsRule = (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)(position = parameters.getPosition()), DroolsRuleStatement.class)) != null) {
                    List<DroolsRhs> rhs;
                    if (droolsRule.getLhs() == null && ((rhs = droolsRule.getRhsList()).size() == 0 || rhs.size() == 1 && rhs.iterator().next().getTextRange().getStartOffset() > position.getTextRange().getStartOffset())) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)"when").bold());
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"then  end").withPresentableText("then").bold().withTailText(" end").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (item == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            Editor editor = context.getEditor();
                            editor.getCaretModel().moveToOffset(context.getTailOffset() - 4);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "context";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "item";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$3$1";
                            objectArray[2] = "handleInsert";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void extendKeywords() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiElement parent;
                if (psiElement == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((parent = psiElement.getParent()) instanceof DroolsFile || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsFile) {
                    return true;
                }
                return parent instanceof DroolsRuleStatement || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsRuleStatement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$4", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    5.$$$reportNull$$$0(2);
                }
                for (String keyword : Arrays.asList("package ", "import ", "rule ", "function ", "declare ", "global ")) {
                    result.addElement(LookupElementBuilder.create((String)keyword).bold().withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$5";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void extendDialectAttribute() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (psiElement.getParent() instanceof DroolsStringLiteral) {
                    DroolsAttribute attribute = (DroolsAttribute)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsAttribute.class);
                    return attribute != null && "dialect".equals(attribute.getAttributeName());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$6", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    7.$$$reportNull$$$0(2);
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"mvel").bold());
                result.addElement((LookupElement)LookupElementBuilder.create((String)"java").bold());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$7";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void extendAttributes() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiElement parent;
                if (psiElement == null) {
                    8.$$$reportNull$$$0(0);
                }
                if ((parent = psiElement.getParent()) instanceof DroolsFile || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsFile) {
                    return true;
                }
                return parent instanceof DroolsRuleStatement || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsRuleStatement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$8", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    9.$$$reportNull$$$0(2);
                }
                List<String> stringAttrs = Arrays.asList("agenda-group", "activation-group", "ruleflow-group", "date-effective", "date-expires", "dialect");
                for (IElementType elementType : DroolsTokenTypeSets.KEYWORD_ATTRS.getTypes()) {
                    String keyword = elementType.toString();
                    if (stringAttrs.contains(keyword)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)(keyword + " \"\"")).bold().withPresentableText(keyword).withTailText(" \"\"", true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                                if (context == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (item == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                Editor editor = context.getEditor();
                                editor.getCaretModel().moveToOffset(context.getTailOffset() - 1);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "context";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "item";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$9$1";
                                objectArray[2] = "handleInsert";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }));
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$9";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void extendPatternBindExpressions() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsPatternBind"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiElement prevSibling;
                if (psiElement == null) {
                    10.$$$reportNull$$$0(0);
                }
                if ((prevSibling = DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(psiElement, true)) != null) {
                    return prevSibling.getNode().getElementType() == DroolsTokenTypes.COLON;
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiErrorElement) {
                    return DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(parent, true) instanceof DroolsLhs;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$10", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiFile file;
                if (parameters == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    11.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    11.$$$reportNull$$$0(2);
                }
                if ((file = parameters.getPosition().getContainingFile()) instanceof DroolsFile) {
                    for (PsiClass psiClass : DroolsResolveUtil.getExplicitlyImportedClasses((DroolsFile)file)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)psiClass).withIcon(psiClass.getIcon(0)).appendTailText("(expression)", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$11";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            DroolsCompletionContributor.$$$reportNull$$$0(0);
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        super.beforeCompletion(context);
        PsiFile file = context.getFile();
        if (file instanceof DroolsFile) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    private void extendRhsStatement() {
        PsiElementPattern.Capture rhsKeywordPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("rhsKeywords"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiStatement type;
                PsiFile file;
                if (psiElement == null) {
                    12.$$$reportNull$$$0(0);
                }
                return (file = psiElement.getContainingFile()) instanceof DroolsFile && (type = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiStatement.class)) != null && psiElement.getTextRange().getStartOffset() == type.getTextRange().getStartOffset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$12", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)rhsKeywordPattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    13.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    13.$$$reportNull$$$0(2);
                }
                for (String keyword : Arrays.asList("insert", "insertLogical", "retract", "update")) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold().withIcon(DroolsIcons.Drools_16).appendTailText("(expression)", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"modify").bold().withIcon(DroolsIcons.Drools_16).appendTailText("(expression){}", true).withInsertHandler((InsertHandler)new MyModifyStatementInsertHandler()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$13";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/plugins/drools/completion/DroolsCompletionContributor", "beforeCompletion"));
    }

    private static class MyModifyStatementInsertHandler
    extends ParenthesesInsertHandler {
        private MyModifyStatementInsertHandler() {
        }

        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return true;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                MyModifyStatementInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MyModifyStatementInsertHandler.$$$reportNull$$$0(1);
            }
            super.handleInsert(context, item);
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            document.insertString(context.getTailOffset(), (CharSequence)"{}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/plugins/drools/completion/DroolsCompletionContributor$MyModifyStatementInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

