/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Conflict;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.MergeResponse;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.actions.SingleItemAction;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ConflictsEnvironment;
import org.jetbrains.tfsIntegration.core.tfs.conflicts.ResolveConflictHelper;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.MergeBranchDialog;

public class MergeBranchAction
extends SingleItemAction
implements DumbAware {
    @Override
    protected void execute(@NotNull Project project, @NotNull WorkspaceInfo workspace, @NotNull FilePath localPath, @NotNull ExtendedItem extendedItem) throws TfsException {
        Collection<Conflict> unresolvedConflicts;
        if (project == null) {
            MergeBranchAction.$$$reportNull$$$0(0);
        }
        if (workspace == null) {
            MergeBranchAction.$$$reportNull$$$0(1);
        }
        if (localPath == null) {
            MergeBranchAction.$$$reportNull$$$0(2);
        }
        if (extendedItem == null) {
            MergeBranchAction.$$$reportNull$$$0(3);
        }
        String title = "Merge Branch Changes";
        MergeBranchDialog d = new MergeBranchDialog(project, workspace, extendedItem.getSitem(), extendedItem.getType() == ItemType.Folder, "Merge Branch Changes");
        if (!d.showAndGet()) {
            return;
        }
        if (!workspace.hasLocalPathForServerPath(d.getTargetPath(), project)) {
            String message = MessageFormat.format("No mapping found for ''{0}'' in workspace ''{1}''.", d.getTargetPath(), workspace.getName());
            Messages.showErrorDialog((Project)project, (String)message, (String)"Merge Branch Changes");
            return;
        }
        MergeResponse mergeResponse = workspace.getServer().getVCS().merge(workspace.getName(), workspace.getOwnerName(), d.getSourcePath(), d.getTargetPath(), d.getFromVersion(), d.getToVersion(), project, TFSBundle.message("merging", new Object[0]));
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        if (mergeResponse.getMergeResult().getGetOperation() != null) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (project == null) {
                    MergeBranchAction.$$$reportNull$$$0(4);
                }
                if (workspace == null) {
                    MergeBranchAction.$$$reportNull$$$0(5);
                }
                Collection<VcsException> applyErrors = ApplyGetOperations.execute(project, workspace, Arrays.asList(mergeResponse.getMergeResult().getGetOperation()), new ApplyProgress.ProgressIndicatorWrapper(ProgressManager.getInstance().getProgressIndicator()), null, ApplyGetOperations.DownloadMode.ALLOW);
                errors.addAll(applyErrors);
            }, "Merge Branch Changes", false, project);
        }
        if (!(unresolvedConflicts = ResolveConflictHelper.getUnresolvedConflicts(mergeResponse.getConflicts().getConflict() != null ? Arrays.asList(mergeResponse.getConflicts().getConflict()) : Collections.emptyList())).isEmpty()) {
            ResolveConflictHelper resolveConflictHelper = new ResolveConflictHelper(project, Collections.singletonMap(workspace, unresolvedConflicts), null);
            ConflictsEnvironment.getConflictsHandler().resolveConflicts(resolveConflictHelper);
        }
        if (mergeResponse.getFailures().getFailure() != null) {
            errors.addAll(TfsUtil.getVcsExceptions(Arrays.asList(mergeResponse.getFailures().getFailure())));
        }
        if (errors.isEmpty()) {
            String message;
            FilePath targetLocalPath = workspace.findLocalPathByServerPath(d.getTargetPath(), true, project);
            for (VirtualFile root : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                if (!targetLocalPath.isUnder(TfsFileUtil.getFilePath(root), false)) continue;
                TfsFileUtil.refreshAndInvalidate(project, new FilePath[]{targetLocalPath}, true);
                break;
            }
            if (unresolvedConflicts.isEmpty() && mergeResponse.getMergeResult().getGetOperation() == null) {
                message = MessageFormat.format("No changes to merge from ''{0}'' to ''{1}''.", d.getSourcePath(), d.getTargetPath());
                TfsUtil.showBalloon(project, MessageType.INFO, message);
            } else {
                message = MessageFormat.format("Changes merged successfully from ''{0}'' to ''{1}''.", d.getSourcePath(), d.getTargetPath());
                TfsUtil.showBalloon(project, MessageType.INFO, message);
            }
        } else {
            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, "TFS");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedItem";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/actions/MergeBranchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

