/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jcifs.util.Base64;
import org.jetbrains.tfsIntegration.checkin.PolicyDescriptor;
import org.jetbrains.tfsIntegration.checkin.PolicyParseException;
import org.jetbrains.tfsIntegration.checkin.PolicyType;

public class StatelessPolicyParser {
    public static List<PolicyDescriptor> parseDescriptors(String input) throws PolicyParseException {
        byte[] data = Base64.decode((String)input);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ArrayList<PolicyDescriptor> descriptors = new ArrayList<PolicyDescriptor>();
        while (is.available() > 0) {
            try {
                String name = StatelessPolicyParser.readString(is);
                String className = StatelessPolicyParser.readString(is);
                StatelessPolicyParser.readString(is);
                String installationInstructions = StatelessPolicyParser.readString(is);
                boolean enabled = StatelessPolicyParser.readBoolean(is);
                int length = StatelessPolicyParser.readInt32(is);
                StatelessPolicyParser.readBytes(is, length);
                PolicyType policyType = new PolicyType(className, name, "", installationInstructions);
                descriptors.add(new PolicyDescriptor(policyType, enabled));
            }
            catch (IOException e) {
                throw new PolicyParseException("Unexpected end of data stream");
            }
        }
        return descriptors;
    }

    private static boolean readBoolean(InputStream is) throws PolicyParseException, IOException {
        int i = is.read();
        if (i == -1) {
            throw new PolicyParseException("Unexpected end of data stream");
        }
        return i != 0;
    }

    private static String readString(InputStream is) throws PolicyParseException, IOException {
        int length = StatelessPolicyParser.read7BitEncodedInt(is);
        byte[] buf = StatelessPolicyParser.readBytes(is, length);
        return new String(buf, 0, length);
    }

    private static byte[] readBytes(InputStream is, int len) throws PolicyParseException, IOException {
        byte[] buf = new byte[len];
        if (is.read(buf, 0, len) != len) {
            throw new PolicyParseException("Unexpected end of data stream");
        }
        return buf;
    }

    private static int read7BitEncodedInt(InputStream is) throws PolicyParseException, IOException {
        int num3;
        int num = 0;
        int num2 = 0;
        do {
            if (num2 == 35) {
                throw new PolicyParseException("Unexpected end of data stream");
            }
            num3 = is.read();
            if (num3 == -1) {
                throw new PolicyParseException("Unexpected end of data stream");
            }
            num |= (num3 & 0x7F) << num2;
            num2 += 7;
        } while ((num3 & 0x80) != 0);
        return num;
    }

    private static int readInt32(InputStream is) throws PolicyParseException, IOException {
        byte[] buf = new byte[4];
        if (is.read(buf, 0, 4) != 4) {
            throw new PolicyParseException("Unexpected end of data stream");
        }
        int i = buf[0] & 0xFF;
        i |= (buf[1] & 0xFF) << 8;
        i |= (buf[2] & 0xFF) << 16;
        return i |= (buf[3] & 0xFF) << 24;
    }
}

