/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

class ChangelistBuilderStatusVisitor
implements StatusVisitor {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final WorkspaceInfo myWorkspace;

    ChangelistBuilderStatusVisitor(@NotNull Project project, @NotNull ChangelistBuilder changelistBuilder, @NotNull WorkspaceInfo workspace) {
        if (project == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(0);
        }
        if (changelistBuilder == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(1);
        }
        if (workspace == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myChangelistBuilder = changelistBuilder;
        this.myWorkspace = workspace;
    }

    @Override
    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(3);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(4);
        }
        if (localItemExists) {
            this.myChangelistBuilder.processUnversionedFile(localPath.getVirtualFile());
        }
    }

    @Override
    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(5);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(6);
        }
        if (localItemExists) {
            TFSContentRevision baseRevision = TFSContentRevision.create(this.myProject, this.myWorkspace, localPath, serverStatus.localVer, serverStatus.itemId);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)baseRevision, CurrentContentRevision.create((FilePath)localPath)), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(7);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(8);
        }
        if (localItemExists) {
            this.myChangelistBuilder.processChange(new Change(null, (ContentRevision)new CurrentContentRevision(localPath)), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(9);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(10);
        }
        TFSContentRevision baseRevision = TFSContentRevision.create(this.myProject, this.myWorkspace, localPath, serverStatus.localVer, serverStatus.itemId);
        this.myChangelistBuilder.processChange(new Change((ContentRevision)baseRevision, null), TFSVcs.getKey());
    }

    @Override
    public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatusm) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(11);
        }
        if (serverStatusm == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(12);
        }
        this.upToDate(localPath, localItemExists, serverStatusm);
    }

    @Override
    public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(13);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(14);
        }
        if (localItemExists) {
            this.myChangelistBuilder.processUnversionedFile(localPath.getVirtualFile());
        }
    }

    @Override
    public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(15);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(16);
        }
        if (localItemExists) {
            if (!this.myWorkspace.isLocal() && TfsFileUtil.isFileWritable(localPath)) {
                this.myChangelistBuilder.processModifiedWithoutCheckout(localPath.getVirtualFile());
            }
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(17);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(18);
        }
        if (localItemExists) {
            FilePath beforePath = this.myWorkspace.findLocalPathByServerPath(serverStatus.sourceItem, serverStatus.isDirectory, this.myProject);
            TFSContentRevision before = TFSContentRevision.create(this.myProject, this.myWorkspace, beforePath, serverStatus.localVer, serverStatus.itemId);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(19);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(20);
        }
        if (localItemExists) {
            FilePath beforePath = this.myWorkspace.findLocalPathByServerPath(serverStatus.sourceItem, serverStatus.isDirectory, this.myProject);
            TFSContentRevision before = TFSContentRevision.create(this.myProject, this.myWorkspace, beforePath, serverStatus.localVer, serverStatus.itemId);
            ContentRevision after = CurrentContentRevision.create((FilePath)localPath);
            this.myChangelistBuilder.processChange(new Change((ContentRevision)before, after), TFSVcs.getKey());
        } else {
            this.myChangelistBuilder.processLocallyDeletedFile(localPath);
        }
    }

    @Override
    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
        if (localPath == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(21);
        }
        if (serverStatus == null) {
            ChangelistBuilderStatusVisitor.$$$reportNull$$$0(22);
        }
        this.checkedOutForEdit(localPath, localItemExists, serverStatus);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverStatus";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverStatusm";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/core/ChangelistBuilderStatusVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "unversioned";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkedOutForEdit";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduledForAddition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduledForDeletion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "outOfDate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "deleted";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "upToDate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "renamed";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "renamedCheckedOut";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "undeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

