/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.ChangelistBuilderStatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.RootsCollection;
import org.jetbrains.tfsIntegration.core.tfs.StatusProvider;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSChangeProvider
implements ChangeProvider {
    private final Project myProject;

    public TFSChangeProvider(Project project) {
        this.myProject = project;
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, final @NotNull ChangelistBuilder builder, final @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            TFSChangeProvider.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            TFSChangeProvider.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            TFSChangeProvider.$$$reportNull$$$0(2);
        }
        if (addGate == null) {
            TFSChangeProvider.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        if (builder == null) {
            return;
        }
        progress.setText("Processing changes");
        RootsCollection.FilePathRootsCollection roots = new RootsCollection.FilePathRootsCollection();
        roots.addAll(dirtyScope.getRecursivelyDirtyDirectories());
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        for (FilePath dirtyFile : dirtyScope.getDirtyFiles()) {
            if (dirtyFile.getVirtualFile() != null && changeListManager.isIgnoredFile(dirtyFile.getVirtualFile())) continue;
            roots.add(dirtyFile);
        }
        if (roots.isEmpty()) {
            return;
        }
        try {
            final Ref mappingFound = Ref.create((Object)false);
            WorkstationHelper.processByWorkspaces((Collection<? extends FilePath>)((Object)roots), true, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    StatusProvider.visitByStatus(workspace, paths, true, progress, new ChangelistBuilderStatusVisitor(TFSChangeProvider.this.myProject, builder, workspace), TFSChangeProvider.this.myProject);
                    mappingFound.set((Object)true);
                }
            });
            if (!((Boolean)mappingFound.get()).booleanValue()) {
                String message;
                if (roots.size() > 1) {
                    message = "Team Foundation Server mappings not found";
                } else {
                    FilePath orphan = (FilePath)roots.iterator().next();
                    message = MessageFormat.format("Team Foundation Server mappings not found for ''{0}''", orphan.getPresentableUrl());
                }
                throw new VcsException(message);
            }
        }
        catch (TfsException e) {
            throw new VcsException(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dirtyScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "progress";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "addGate";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/tfsIntegration/core/TFSChangeProvider";
        objectArray[2] = "getChanges";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

