/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.tfsIntegration.core.TFSFileRevision;

public class AnnotationBuilder {
    private final String myAnnotatedContent;
    private final VcsFileRevision[] myLineRevisions;
    private final List<Integer> myLineNumbers;

    public AnnotationBuilder(List<TFSFileRevision> revisions, ContentProvider contentProvider) throws VcsException {
        if (revisions == null || revisions.size() < 1) {
            throw new IllegalArgumentException();
        }
        Iterator<TFSFileRevision> iterator = revisions.iterator();
        TFSFileRevision revision = iterator.next();
        this.myAnnotatedContent = contentProvider.getContent(revision);
        Object[] lines = AnnotationBuilder.splitLines(this.myAnnotatedContent);
        this.myLineRevisions = new VcsFileRevision[lines.length];
        this.myLineNumbers = new ArrayList<Integer>(lines.length);
        for (int i = 0; i < lines.length; ++i) {
            this.myLineNumbers.add(i);
        }
        while (iterator.hasNext()) {
            Diff.Change change;
            TFSFileRevision previousRevision = iterator.next();
            String previousContent = contentProvider.getContent(previousRevision);
            Object[] previousLines = AnnotationBuilder.splitLines(previousContent);
            try {
                change = Diff.buildChanges((Object[])previousLines, (Object[])lines);
            }
            catch (FilesTooBigForDiffException e) {
                throw new VcsException((Throwable)e);
            }
            this.annotateAll(change, revision);
            if (this.allLinesAnnotated()) break;
            lines = previousLines;
            revision = previousRevision;
        }
        this.fillAllNotAnnotated(revisions.get(revisions.size() - 1));
    }

    private void annotateAll(Diff.Change changesList, VcsFileRevision revision) {
        Diff.Change change = changesList;
        while (change != null) {
            this.annotate(change, revision);
            change = change.link;
        }
        this.recalculateLineNumbers(changesList);
    }

    private void annotate(Diff.Change change, VcsFileRevision revision) {
        if (change.inserted > 0) {
            for (int line = change.line1; line < change.line1 + change.inserted; ++line) {
                Integer origLine = this.myLineNumbers.get(line);
                if (origLine == null || this.myLineRevisions[origLine] != null) continue;
                this.myLineRevisions[origLine.intValue()] = revision;
            }
        }
    }

    private void recalculateLineNumbers(Diff.Change changesList) {
        int i;
        Diff.Change change = changesList;
        int removedLinesCount = 0;
        while (change != null) {
            for (i = 0; i < change.inserted; ++i) {
                this.myLineNumbers.remove(change.line1 - removedLinesCount);
            }
            removedLinesCount += change.inserted;
            change = change.link;
        }
        change = changesList;
        while (change != null) {
            for (i = 0; i < change.deleted; ++i) {
                this.myLineNumbers.add(change.line0, null);
            }
            change = change.link;
        }
    }

    private boolean allLinesAnnotated() {
        for (VcsFileRevision revision : this.myLineRevisions) {
            if (revision != null) continue;
            return false;
        }
        return true;
    }

    private void fillAllNotAnnotated(VcsFileRevision vcsFileRevision) {
        for (int i = 0; i < this.myLineRevisions.length; ++i) {
            if (this.myLineRevisions[i] != null) continue;
            this.myLineRevisions[i] = vcsFileRevision;
        }
    }

    private static String[] splitLines(String string) {
        string = StreamUtil.convertSeparators((String)string);
        boolean spaceAdded = false;
        if (string.endsWith("\n")) {
            string = string + " ";
            spaceAdded = true;
        }
        String[] temp = string.split("\n");
        if (spaceAdded) {
            String[] result = new String[temp.length - 1];
            System.arraycopy(temp, 0, result, 0, result.length);
            return result;
        }
        return temp;
    }

    public String getAnnotatedContent() {
        return this.myAnnotatedContent;
    }

    public VcsFileRevision[] getLineRevisions() {
        return this.myLineRevisions;
    }

    public static interface ContentProvider {
        public String getContent(TFSFileRevision var1) throws VcsException;
    }
}

