/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSProgressUtil;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;

public class TfsExecutionUtil {
    public static <T> ResultWithErrors<T> executeInBackground(String progressText, Project project, ProcessWithErrors<? extends T> process) {
        boolean completed;
        Ref result = new Ref();
        ArrayList errors = new ArrayList();
        Ref explicitlyCancelled = new Ref();
        Runnable runnable = () -> {
            TFSProgressUtil.setIndeterminate(ProgressManager.getInstance().getProgressIndicator(), true);
            try {
                result.set(process.run(errors));
            }
            catch (UserCancelledException e) {
                explicitlyCancelled.set((Object)true);
            }
            catch (TfsException e) {
                errors.add(new VcsException(e.getMessage(), (Throwable)e));
            }
            catch (VcsException e) {
                errors.add(e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, progressText, true, project);
        } else {
            runnable.run();
            completed = true;
        }
        return new ResultWithErrors(errors, result.get(), project, !completed || !explicitlyCancelled.isNull() && (Boolean)explicitlyCancelled.get() != false);
    }

    public static ResultWithErrors<Void> executeInBackground(String progressText, Project project, final VoidProcessWithErrors process) {
        return TfsExecutionUtil.executeInBackground(progressText, project, new ProcessWithErrors<Void>(){

            @Override
            public Void run(Collection<VcsException> errorsHolder) throws TfsException, VcsException {
                process.run(errorsHolder);
                return null;
            }
        });
    }

    public static <T> ResultWithError<T> executeInBackground(String progressText, Project project, final Process<? extends T> process) {
        ResultWithErrors<T> result = TfsExecutionUtil.executeInBackground(progressText, project, new ProcessWithErrors<T>(){

            @Override
            public T run(Collection<VcsException> errorsHolder) throws TfsException, VcsException {
                return process.run();
            }
        });
        assert (result.errors.size() < 2);
        return new ResultWithError((VcsException)((Object)ContainerUtil.getFirstItem(result.errors, null)), result.result, project, result.cancelled);
    }

    public static ResultWithError<Void> executeInBackground(String progressText, Project project, final VoidProcess process) {
        return TfsExecutionUtil.executeInBackground(progressText, project, new Process<Void>(){

            @Override
            public Void run() throws TfsException, VcsException {
                process.run();
                return null;
            }
        });
    }

    public static interface VoidProcess {
        public void run() throws TfsException, VcsException;
    }

    public static interface Process<T> {
        @Nullable
        public T run() throws TfsException, VcsException;
    }

    public static interface VoidProcessWithErrors {
        public void run(Collection<VcsException> var1) throws TfsException, VcsException;
    }

    public static interface ProcessWithErrors<T> {
        @Nullable
        public T run(Collection<VcsException> var1) throws TfsException, VcsException;
    }

    public static class ResultWithError<T> {
        @Nullable
        public final VcsException error;
        @Nullable
        public final T result;
        @NotNull
        private final Project project;
        public final boolean cancelled;

        private ResultWithError(@Nullable VcsException error, @Nullable T result, Project project, boolean cancelled) {
            this.error = error;
            this.result = result;
            this.project = project;
            this.cancelled = cancelled;
        }

        public void throwIfError() throws VcsException {
            if (this.error != null) {
                throw new VcsException((Throwable)this.error);
            }
        }

        public boolean showTabIfError() {
            if (this.error != null) {
                AbstractVcsHelper.getInstance((Project)this.project).showError(this.error, "TFS");
                return true;
            }
            return false;
        }

        public boolean showDialogIfError(String title) {
            if (this.error == null) {
                return false;
            }
            Messages.showErrorDialog((Project)this.project, (String)this.error.getMessage(), (String)title);
            return true;
        }
    }

    public static class ResultWithErrors<T> {
        public final List<VcsException> errors;
        @Nullable
        public final T result;
        @NotNull
        private final Project project;
        public final boolean cancelled;

        private ResultWithErrors(List<VcsException> errors, T result, Project project, boolean cancelled) {
            this.errors = errors;
            this.result = result;
            this.project = project;
            this.cancelled = cancelled;
        }

        public void throwIfErrors() throws VcsException {
            if (this.errors.isEmpty()) {
                return;
            }
            if (this.errors.size() == 1) {
                throw this.errors.iterator().next();
            }
            ArrayList<String> messages = new ArrayList<String>(this.errors.size());
            for (VcsException error : this.errors) {
                messages.add(error.getMessage());
            }
            throw new VcsException(messages);
        }

        public boolean showTabIfErrors() {
            if (this.errors.isEmpty()) {
                return false;
            }
            AbstractVcsHelper.getInstance((Project)this.project).showErrors(this.errors, "TFS");
            return true;
        }

        public boolean showDialogIfErrors(String title, String prefix) {
            if (this.errors.isEmpty()) {
                return false;
            }
            StringBuilder errorMessage = new StringBuilder(prefix + ":\n\n");
            for (VcsException e : this.errors) {
                errorMessage.append(e.getMessage()).append("\n");
            }
            Messages.showErrorDialog((Project)this.project, (String)errorMessage.toString(), (String)title);
            return true;
        }
    }
}

