/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.vcs.FilePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class WorkstationHelper {
    private WorkstationHelper() {
    }

    public static List<FilePath> processByWorkspaces(Collection<? extends FilePath> localPaths, boolean considerChildMappings, Object projectOrComponent, VoidProcessDelegate processor) throws TfsException {
        ArrayList<FilePath> orphanPaths = new ArrayList<FilePath>();
        HashMap<WorkspaceInfo, ArrayList<FilePath>> workspace2localPaths = new HashMap<WorkspaceInfo, ArrayList<FilePath>>();
        for (FilePath filePath : localPaths) {
            Collection<WorkspaceInfo> workspaces = Workstation.getInstance().findWorkspaces(filePath, considerChildMappings, projectOrComponent);
            if (!workspaces.isEmpty()) {
                for (WorkspaceInfo workspace : workspaces) {
                    ArrayList<FilePath> workspaceLocalPaths = (ArrayList<FilePath>)workspace2localPaths.get(workspace);
                    if (workspaceLocalPaths == null) {
                        workspaceLocalPaths = new ArrayList<FilePath>();
                        workspace2localPaths.put(workspace, workspaceLocalPaths);
                    }
                    workspaceLocalPaths.add(filePath);
                }
                continue;
            }
            orphanPaths.add(filePath);
        }
        for (WorkspaceInfo workspaceInfo : workspace2localPaths.keySet()) {
            List currentLocalPaths = (List)workspace2localPaths.get(workspaceInfo);
            ArrayList<ItemPath> currentItemPaths = new ArrayList<ItemPath>(currentLocalPaths.size());
            for (FilePath localPath : currentLocalPaths) {
                Collection<String> serverPaths = workspaceInfo.findServerPathsByLocalPath(localPath, considerChildMappings, projectOrComponent);
                if (!considerChildMappings) {
                    currentItemPaths.add(new ItemPath(localPath, serverPaths.iterator().next()));
                    continue;
                }
                for (String serverPath : serverPaths) {
                    currentItemPaths.add(new ItemPath(workspaceInfo.findLocalPathByServerPath(serverPath, localPath.isDirectory(), projectOrComponent), serverPath));
                }
            }
            processor.executeRequest(workspaceInfo, currentItemPaths);
        }
        return orphanPaths;
    }

    public static interface VoidProcessDelegate {
        public void executeRequest(WorkspaceInfo var1, List<ItemPath> var2) throws TfsException;
    }
}

