/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.locks;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;

public class LockItemModel {
    @NotNull
    private final ExtendedItem myExtendedItem;
    @NotNull
    private final WorkspaceInfo myWorkspace;
    @Nullable
    private Boolean mySelectionStatus;
    public static final Comparator<LockItemModel> LOCK_ITEM_PARENT_FIRST = (o1, o2) -> VersionControlPath.compareParentToChild(o1.getExtendedItem().getSitem(), o1.getExtendedItem().getType() == ItemType.Folder, o2.getExtendedItem().getSitem(), o2.getExtendedItem().getType() == ItemType.Folder);

    public LockItemModel(@NotNull ExtendedItem item, @NotNull WorkspaceInfo workspace) {
        if (item == null) {
            LockItemModel.$$$reportNull$$$0(0);
        }
        if (workspace == null) {
            LockItemModel.$$$reportNull$$$0(1);
        }
        this.myExtendedItem = item;
        this.myWorkspace = workspace;
        this.mySelectionStatus = this.canBeLocked() || this.canBeUnlocked() ? Boolean.FALSE : null;
    }

    @NotNull
    public ExtendedItem getExtendedItem() {
        ExtendedItem extendedItem = this.myExtendedItem;
        if (extendedItem == null) {
            LockItemModel.$$$reportNull$$$0(2);
        }
        return extendedItem;
    }

    @NotNull
    public WorkspaceInfo getWorkspace() {
        WorkspaceInfo workspaceInfo = this.myWorkspace;
        if (workspaceInfo == null) {
            LockItemModel.$$$reportNull$$$0(3);
        }
        return workspaceInfo;
    }

    @Nullable
    public Boolean getSelectionStatus() {
        return this.mySelectionStatus;
    }

    public void setSelectionStatus(@NotNull Boolean selectionStatus) {
        if (selectionStatus == null) {
            LockItemModel.$$$reportNull$$$0(4);
        }
        if (this.mySelectionStatus == null) {
            throw new IllegalArgumentException("State of items locked by another user cannot be changed.");
        }
        this.mySelectionStatus = selectionStatus;
    }

    @Nullable
    public String getLockOwner() {
        return this.myExtendedItem.getLowner() != null ? TfsUtil.getNameWithoutDomain(this.myExtendedItem.getLowner()) : null;
    }

    public boolean canBeLocked() {
        return this.myExtendedItem.getLock() == null || this.myExtendedItem.getLock() == LockLevel.None;
    }

    public boolean canBeUnlocked() {
        return this.myWorkspace.isWorkspaceOwner(this.myExtendedItem.getLowner());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/locks/LockItemModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedItem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

