/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.RootsCollection;
import org.jetbrains.tfsIntegration.core.tfs.ServerStatus;
import org.jetbrains.tfsIntegration.core.tfs.StatusProvider;
import org.jetbrains.tfsIntegration.core.tfs.StatusVisitor;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.operations.UndoPendingChanges;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class ScheduleForDeletion {
    public static Collection<VcsException> execute(Project project, WorkspaceInfo workspace, List<ItemPath> paths) {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        try {
            Object change;
            RootsCollection.ItemPathRootsCollection roots = new RootsCollection.ItemPathRootsCollection(paths);
            Collection<PendingChange> pendingChanges = workspace.getServer().getVCS().queryPendingSetsByLocalPaths(workspace.getName(), workspace.getOwnerName(), (Collection<ItemPath>)((Object)roots), RecursionType.Full, project, TFSBundle.message("loading.changes", new Object[0]));
            ArrayList<String> revert = new ArrayList<String>();
            for (PendingChange pendingChange : pendingChanges) {
                change = new ChangeTypeMask(pendingChange.getChg());
                if (((ChangeTypeMask)change).contains(ChangeType_type0.Delete)) continue;
                revert.add(pendingChange.getItem());
            }
            UndoPendingChanges.UndoPendingChangesResult undoResult = UndoPendingChanges.execute(project, workspace, revert, true, ApplyProgress.EMPTY, false);
            errors.addAll(undoResult.errors);
            ArrayList<ItemPath> undoneRoots = new ArrayList<ItemPath>(roots.size());
            change = roots.iterator();
            while (change.hasNext()) {
                ItemPath originalRoot = (ItemPath)change.next();
                ItemPath undoneRoot = undoResult.undonePaths.get(originalRoot);
                undoneRoots.add(undoneRoot != null ? undoneRoot : originalRoot);
            }
            final ArrayList<FilePath> scheduleForDeletion = new ArrayList<FilePath>();
            StatusProvider.visitByStatus(workspace, undoneRoots, false, null, new StatusVisitor(){

                @Override
                public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void deleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(3);
                    }
                }

                @Override
                public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                @Override
                public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                @Override
                public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                @Override
                public void outOfDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(11);
                    }
                    scheduleForDeletion.add(localPath);
                }

                @Override
                public void upToDate(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(13);
                    }
                    scheduleForDeletion.add(localPath);
                }

                @Override
                public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(14);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                @Override
                public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(16);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(17);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                @Override
                public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                    if (localPath == null) {
                        1.$$$reportNull$$$0(18);
                    }
                    if (serverStatus == null) {
                        1.$$$reportNull$$$0(19);
                    }
                    TFSVcs.error("Unexpected status " + serverStatus.getClass().getName() + " for " + localPath.getPresentableUrl());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "localPath";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 13: 
                        case 15: 
                        case 17: 
                        case 19: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "serverStatus";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/tfsIntegration/core/tfs/operations/ScheduleForDeletion$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "unversioned";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "deleted";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "checkedOutForEdit";
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "scheduledForAddition";
                            break;
                        }
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "scheduledForDeletion";
                            break;
                        }
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "outOfDate";
                            break;
                        }
                        case 12: 
                        case 13: {
                            objectArray = objectArray2;
                            objectArray2[2] = "upToDate";
                            break;
                        }
                        case 14: 
                        case 15: {
                            objectArray = objectArray2;
                            objectArray2[2] = "renamed";
                            break;
                        }
                        case 16: 
                        case 17: {
                            objectArray = objectArray2;
                            objectArray2[2] = "renamedCheckedOut";
                            break;
                        }
                        case 18: 
                        case 19: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undeleted";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, project);
            ResultWithFailures<GetOperation> schedulingForDeletionResults = workspace.getServer().getVCS().scheduleForDeletionAndUpateLocalVersion(workspace.getName(), workspace.getOwnerName(), scheduleForDeletion, project, TFSBundle.message("scheduling.for.deletion", new Object[0]));
            errors.addAll(TfsUtil.getVcsExceptions(schedulingForDeletionResults.getFailures()));
            for (GetOperation getOperation : schedulingForDeletionResults.getResult()) {
                TfsFileUtil.markFileDirty(project, VersionControlPath.getFilePath(getOperation.getSlocal(), getOperation.getType() == ItemType.Folder));
            }
        }
        catch (TfsException e) {
            errors.add(new VcsException((Throwable)e));
        }
        return errors;
    }
}

