/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ui.CollectionListModel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.tfsIntegration.checkin.PolicyBase;

public class ChooseCheckinPolicyForm {
    private JList myPoliciesList;
    private JPanel myContentPane;
    private JTextArea myDescriptionArea;
    private final EventDispatcher<Listener> myEventDispatcher;

    public ChooseCheckinPolicyForm(List<PolicyBase> policies) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myPoliciesList.setSelectionMode(0);
        this.myPoliciesList.setModel(new CollectionListModel(policies));
        this.myPoliciesList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setText(((PolicyBase)value).getPolicyType().getName());
                return label;
            }
        });
        this.myPoliciesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PolicyBase policy = ChooseCheckinPolicyForm.this.getSelectedPolicy();
                ChooseCheckinPolicyForm.this.myDescriptionArea.setText(policy != null ? policy.getPolicyType().getDescription() : null);
                ((Listener)ChooseCheckinPolicyForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseCheckinPolicyForm.this.getSelectedPolicy() != null) {
                    ((Listener)ChooseCheckinPolicyForm.this.myEventDispatcher.getMulticaster()).close();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myPoliciesList);
        this.myDescriptionArea.setWrapStyleWord(true);
    }

    public PolicyBase getSelectedPolicy() {
        return (PolicyBase)this.myPoliciesList.getSelectedValue();
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Checkin policies");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myPoliciesList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Description", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myDescriptionArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(6);
        jBScrollPane2.setViewportView(jTextArea);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 2, new Dimension(-1, 10), null, null));
        jLabel.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();

        public void close();
    }
}

