/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;

public class ChooseTeamProjectCollectionForm {
    private JPanel myContentPane;
    private JTextField myAddressField;
    private TableView myTable;
    private JLabel myMessageLabel;
    private final EventDispatcher<Listener> myEventDispatcher;

    public ChooseTeamProjectCollectionForm(String serverAddress, Collection<? extends TfsServerConnectionHelper.TeamProjectCollectionDescriptor> items) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myAddressField.setText(serverAddress);
        ColumnInfo<TfsServerConnectionHelper.TeamProjectCollectionDescriptor, String> displayNameColumn = new ColumnInfo<TfsServerConnectionHelper.TeamProjectCollectionDescriptor, String>(TFSBundle.message("team.project.collection.table.column.display.name", new Object[0])){

            public String valueOf(TfsServerConnectionHelper.TeamProjectCollectionDescriptor teamProjectCollectionDescriptor) {
                return teamProjectCollectionDescriptor.name;
            }
        };
        ArrayList<? extends TfsServerConnectionHelper.TeamProjectCollectionDescriptor> sorted = new ArrayList<TfsServerConnectionHelper.TeamProjectCollectionDescriptor>(items);
        Collections.sort(sorted, (o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
        this.myTable.setTableHeader(null);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((Listener)ChooseTeamProjectCollectionForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    ChooseTeamProjectCollectionForm.this.selected();
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                ChooseTeamProjectCollectionForm.this.selected();
                return true;
            }
        }.installOn((Component)this.myTable);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        new TableSpeedSearch((JTable)this.myTable);
        this.myTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{displayNameColumn}, sorted, 0));
        this.myTable.setSelection(Collections.singletonList(sorted.get(0)));
    }

    private void selected() {
        TfsServerConnectionHelper.TeamProjectCollectionDescriptor selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            ((Listener)this.myEventDispatcher.getMulticaster()).selected();
        }
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    @Nullable
    public TfsServerConnectionHelper.TeamProjectCollectionDescriptor getSelectedItem() {
        return (TfsServerConnectionHelper.TeamProjectCollectionDescriptor)this.myTable.getSelectedObject();
    }

    public void addChangeListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        if (errorMessage != null && !errorMessage.endsWith(".")) {
            errorMessage = errorMessage + ".";
        }
        this.myMessageLabel.setText(errorMessage);
        this.myMessageLabel.setVisible(errorMessage != null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TableView tableView;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Server address:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Team project collections:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 5), new Dimension(-1, 5)));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends ChangeListener {
        public void selected();
    }
}

