/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.ui.BaseQueryNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.SavedQueryDefinitionNode;
import org.jetbrains.tfsIntegration.ui.servertree.TfsErrorTreeNode;

public class SavedQueryFolderNode
extends BaseQueryNode {
    @Nullable
    private final QueryFolder myQueryFolder;
    @Nullable
    private final String myProjectName;

    public SavedQueryFolderNode(@NotNull QueriesTreeContext context, @NotNull QueryFolder folder) {
        if (context == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(0);
        }
        if (folder == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(1);
        }
        super(context);
        this.myQueryFolder = folder;
        this.myProjectName = null;
    }

    public SavedQueryFolderNode(@NotNull QueriesTreeContext context, @NotNull String projectPath) {
        if (context == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(2);
        }
        if (projectPath == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(3);
        }
        super(context);
        this.myQueryFolder = null;
        this.myProjectName = VersionControlPath.getTeamProject(projectPath);
    }

    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.addText(this.getQueryFolderName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.getQueryFolderName()};
        if (objectArray == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    public boolean isProject() {
        return this.myQueryFolder == null;
    }

    @NotNull
    public SimpleNode[] getChildren() {
        ArrayList result = ContainerUtil.newArrayList();
        try {
            result.addAll(TfsUtil.forcePluginClassLoader(new ThrowableComputable<Collection<? extends SimpleNode>, VcsException>(){

                public Collection<? extends SimpleNode> compute() throws VcsException {
                    return SavedQueryFolderNode.this.getChildren(SavedQueryFolderNode.this.getQueryFolder());
                }
            }));
        }
        catch (VcsException e) {
            result.add(this.buildErrorNode((Exception)((Object)e)));
        }
        catch (ProxyException e) {
            result.add(this.buildErrorNode((Exception)((Object)e)));
        }
        SimpleNode[] simpleNodeArray = (SimpleNode[])ArrayUtil.toObjectArray((Collection)result, SimpleNode.class);
        if (simpleNodeArray == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(5);
        }
        return simpleNodeArray;
    }

    @NotNull
    private List<SimpleNode> getChildren(@NotNull QueryFolder folder) {
        if (folder == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(6);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (QueryItem item : folder.getItems()) {
            BaseQueryNode child;
            if (item instanceof QueryDefinition) {
                child = new SavedQueryDefinitionNode(this.myQueriesTreeContext, (QueryDefinition)item);
            } else if (item instanceof QueryFolder) {
                child = new SavedQueryFolderNode(this.myQueriesTreeContext, (QueryFolder)item);
            } else {
                throw new IllegalArgumentException("Unknown query item " + item);
            }
            result.add(child);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private SimpleNode buildErrorNode(@NotNull Exception e) {
        if (e == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(8);
        }
        TfsErrorTreeNode tfsErrorTreeNode = new TfsErrorTreeNode(this, e.getMessage());
        if (tfsErrorTreeNode == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(9);
        }
        return tfsErrorTreeNode;
    }

    @NotNull
    private String getQueryFolderName() {
        String string = (String)ObjectUtils.assertNotNull((Object)(this.myQueryFolder != null ? this.myQueryFolder.getName() : this.myProjectName));
        if (string == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private QueryFolder getQueryFolder() throws VcsException, ProxyException {
        QueryFolder result;
        if (this.myQueryFolder != null) {
            result = this.myQueryFolder;
        } else {
            Project project = this.getWorkItemClient().getProjects().get(this.myProjectName);
            if (project == null) {
                throw new VcsException("Could not find project " + this.myProjectName + " in " + this.getServer().getPresentableUri());
            }
            result = project.getQueryHierarchy();
        }
        QueryFolder queryFolder = result;
        if (queryFolder == null) {
            SavedQueryFolderNode.$$$reportNull$$$0(11);
        }
        return queryFolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryFolderName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildErrorNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

