/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemLinkInfo;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkItemsCheckinParameters;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemState;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItemType;
import org.jetbrains.tfsIntegration.ui.NoBackgroundBooleanTableCellRenderer;

class WorkItemsTableModel
extends ListTreeTableModelOnColumns {
    private static final Logger LOG = Logger.getInstance(WorkItemsTableModel.class);
    @NotNull
    private final DefaultMutableTreeNode myRoot;
    @NotNull
    private final WorkItemsCheckinParameters myContent;
    static WorkItemFieldColumn<WorkItemType> TYPE = new WorkItemFieldColumn<WorkItemType>("Type", 300){

        @Override
        @Nullable
        public WorkItemType valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                1.$$$reportNull$$$0(0);
            }
            return workItem.getType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$1", "valueOf"));
        }
    };
    static WorkItemFieldColumn<Integer> ID = new WorkItemFieldColumn<Integer>("Id", 200){

        @Override
        @Nullable
        public Integer valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                2.$$$reportNull$$$0(0);
            }
            return workItem.getId();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$2", "valueOf"));
        }
    };
    static WorkItemFieldColumn<String> TITLE = new WorkItemFieldColumn<String>("Title", 1500){

        @Override
        @Nullable
        public String valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                3.$$$reportNull$$$0(0);
            }
            return workItem.getTitle();
        }

        public Class<?> getColumnClass() {
            return TreeTableModel.class;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$3", "valueOf"));
        }
    };
    static WorkItemFieldColumn<WorkItemState> STATE = new WorkItemFieldColumn<WorkItemState>("State", 300){

        @Override
        @Nullable
        public WorkItemState valueOf(@NotNull WorkItem workItem) {
            if (workItem == null) {
                4.$$$reportNull$$$0(0);
            }
            return workItem.getState();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workItem", "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$4", "valueOf"));
        }
    };

    WorkItemsTableModel(@NotNull WorkItemsCheckinParameters content) {
        if (content == null) {
            WorkItemsTableModel.$$$reportNull$$$0(0);
        }
        super(null, new ColumnInfo[]{new CheckBoxColumn(content), TYPE, ID, TITLE, STATE, new CheckInActionColumn(content)});
        this.myContent = content;
        this.myRoot = new DefaultMutableTreeNode();
        this.setRoot(this.myRoot);
    }

    @Nullable
    public CheckinWorkItemAction getAction(@NotNull WorkItem workItem) {
        if (workItem == null) {
            WorkItemsTableModel.$$$reportNull$$$0(1);
        }
        return this.myContent.getAction(workItem);
    }

    public void setContent(@NotNull WorkItemsCheckinParameters content) {
        if (content == null) {
            WorkItemsTableModel.$$$reportNull$$$0(2);
        }
        this.myContent.update(content);
        this.myRoot.removeAllChildren();
        this.buildModel();
        this.reload(this.myRoot);
    }

    private void buildModel() {
        List<WorkItemLinkInfo> links = this.myContent.getLinks();
        if (!ContainerUtil.isEmpty(links)) {
            this.buildTreeModel(links);
        } else {
            this.buildFlatModel();
        }
    }

    private void buildTreeModel(@NotNull List<WorkItemLinkInfo> links) {
        if (links == null) {
            WorkItemsTableModel.$$$reportNull$$$0(3);
        }
        this.validateLinksStructure(links);
        Map workItemsMap = ContainerUtil.map2Map(this.myContent.getWorkItems(), workItem -> Pair.create((Object)workItem.getId(), (Object)new DefaultMutableTreeNode(workItem)));
        workItemsMap.put(0, this.myRoot);
        for (WorkItemLinkInfo link : links) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)workItemsMap.get(link.getSourceID());
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)workItemsMap.get(link.getTargetID());
            if (parentNode != null && childNode != null) {
                parentNode.add(childNode);
                continue;
            }
            LOG.info("Could not resolve work item link " + link.getSourceID() + "-" + link.getTargetID());
        }
    }

    private void validateLinksStructure(@NotNull List<WorkItemLinkInfo> links) {
        if (links == null) {
            WorkItemsTableModel.$$$reportNull$$$0(4);
        }
        if (links.size() != this.myContent.getWorkItems().size()) {
            String linksValue = StringUtil.join(links, info -> info.getSourceID() + " - " + info.getTargetID(), (String)", ");
            String workItemIdsValue = StringUtil.join(this.myContent.getWorkItems(), workItem -> String.valueOf(workItem.getId()), (String)", ");
            LOG.error("Unknown work item links structure\nLinks: " + linksValue + "\nWork Items: " + workItemIdsValue);
        }
    }

    private void buildFlatModel() {
        for (WorkItem workItem : this.myContent.getWorkItems()) {
            this.myRoot.add(new DefaultMutableTreeNode(workItem));
        }
    }

    public void setValueAt(Object aValue, Object node, int column) {
        super.setValueAt(aValue, node, column);
        this.nodeChanged((TreeNode)node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workItem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTreeModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateLinksStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CheckInActionColumn
    extends WorkItemFieldColumn<CheckinWorkItemAction> {
        private final ComboBox myComboBox;
        private final TableCellEditor myCellEditor;
        @NotNull
        private final WorkItemsCheckinParameters myContent;

        CheckInActionColumn(@NotNull WorkItemsCheckinParameters content) {
            if (content == null) {
                CheckInActionColumn.$$$reportNull$$$0(0);
            }
            super("Checkin Action", 400);
            this.myComboBox = new ComboBox((Object[])new CheckinWorkItemAction[]{CheckinWorkItemAction.Resolve, CheckinWorkItemAction.Associate});
            this.myCellEditor = new DefaultCellEditor((JComboBox)this.myComboBox){

                @Override
                @Nullable
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    WorkItem workItem;
                    TreeTable treeTable = (TreeTable)table;
                    WorkItemsTableModel model = (WorkItemsTableModel)treeTable.getTableModel();
                    CheckinWorkItemAction action = model.getAction(workItem = (WorkItem)((DefaultMutableTreeNode)treeTable.getTree().getPathForRow(row).getLastPathComponent()).getUserObject());
                    if (action != null && workItem.isActionPossible(CheckinWorkItemAction.Resolve)) {
                        myComboBox.setSelectedItem((Object)action);
                        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    }
                    return null;
                }
            };
            this.myContent = content;
        }

        @Override
        @Nullable
        public CheckinWorkItemAction valueOf(@NotNull WorkItem workItem) {
            CheckinWorkItemAction action;
            if (workItem == null) {
                CheckInActionColumn.$$$reportNull$$$0(1);
            }
            return CheckinWorkItemAction.None.equals((Object)(action = this.myContent.getAction(workItem))) ? null : action;
        }

        public boolean isCellEditable(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                CheckInActionColumn.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Nullable
        public TableCellEditor getEditor(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                CheckInActionColumn.$$$reportNull$$$0(3);
            }
            return this.myCellEditor;
        }

        @Override
        public void setValue(@NotNull WorkItem workItem, @NotNull CheckinWorkItemAction value) {
            if (workItem == null) {
                CheckInActionColumn.$$$reportNull$$$0(4);
            }
            if (value == null) {
                CheckInActionColumn.$$$reportNull$$$0(5);
            }
            this.myContent.setAction(workItem, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workItem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckInActionColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCellEditable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CheckBoxColumn
    extends WorkItemFieldColumn<Boolean> {
        @NotNull
        private final WorkItemsCheckinParameters myContent;
        private final TableCellRenderer myRenderer;

        CheckBoxColumn(@NotNull WorkItemsCheckinParameters content) {
            if (content == null) {
                CheckBoxColumn.$$$reportNull$$$0(0);
            }
            super(" ", 50);
            this.myRenderer = new NoBackgroundBooleanTableCellRenderer();
            this.myContent = content;
        }

        @Override
        @Nullable
        public Boolean valueOf(@NotNull WorkItem workItem) {
            CheckinWorkItemAction action;
            if (workItem == null) {
                CheckBoxColumn.$$$reportNull$$$0(1);
            }
            return (action = this.myContent.getAction(workItem)) != null && action != CheckinWorkItemAction.None;
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public boolean isCellEditable(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                CheckBoxColumn.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Nullable
        public TableCellRenderer getRenderer(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                CheckBoxColumn.$$$reportNull$$$0(3);
            }
            return this.myRenderer;
        }

        @Override
        public void setValue(@NotNull WorkItem workItem, @NotNull Boolean value) {
            if (workItem == null) {
                CheckBoxColumn.$$$reportNull$$$0(4);
            }
            if (value == null) {
                CheckBoxColumn.$$$reportNull$$$0(5);
            }
            if (value == Boolean.TRUE) {
                CheckinWorkItemAction action = workItem.isActionPossible(CheckinWorkItemAction.Resolve) ? CheckinWorkItemAction.Resolve : CheckinWorkItemAction.Associate;
                this.myContent.setAction(workItem, action);
            } else {
                this.myContent.removeAction(workItem);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workItem";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$CheckBoxColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCellEditable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRenderer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class WorkItemFieldColumn<Aspect>
    extends ColumnInfo<DefaultMutableTreeNode, Aspect> {
        private final int myWidth;

        WorkItemFieldColumn(@NotNull String name, int width) {
            if (name == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(0);
            }
            super(name);
            this.myWidth = width;
        }

        @Nullable
        public String getPreferredStringValue() {
            return "";
        }

        public int getAdditionalWidth() {
            return this.myWidth;
        }

        @Nullable
        public Aspect valueOf(@NotNull DefaultMutableTreeNode node) {
            Object userObject;
            if (node == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(1);
            }
            return (userObject = node.getUserObject()) instanceof WorkItem ? (Aspect)this.valueOf((WorkItem)userObject) : null;
        }

        public void setValue(@NotNull DefaultMutableTreeNode node, @NotNull Aspect value) {
            if (node == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(2);
            }
            if (value == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(3);
            }
            if (node.getUserObject() instanceof WorkItem) {
                this.setValue((WorkItem)node.getUserObject(), value);
            }
        }

        public void setValue(@NotNull WorkItem workItem, @NotNull Aspect value) {
            if (workItem == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(4);
            }
            if (value == null) {
                WorkItemFieldColumn.$$$reportNull$$$0(5);
            }
        }

        @Nullable
        public abstract Aspect valueOf(@NotNull WorkItem var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workItem";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/tfsIntegration/ui/WorkItemsTableModel$WorkItemFieldColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

