/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class Type
implements Named {
    private static final Set<String> PRIMITIVE_CLASS_NAMES = new HashSet<String>(Arrays.asList("void", "byte", "short", "int", "long", "float", "double", "boolean", "char"));
    private final String myClassName;
    private final boolean myIsArray;

    Type(String className, boolean isArray) {
        this.myClassName = className;
        this.myIsArray = isArray;
    }

    @NotNull
    String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            Type.$$$reportNull$$$0(0);
        }
        return string;
    }

    boolean isArray() {
        return this.myIsArray;
    }

    boolean isPrimitive() {
        return PRIMITIVE_CLASS_NAMES.contains(this.myClassName);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.isArray() ? this.myClassName + "[]" : this.myClassName;
        if (string == null) {
            Type.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static Type parse(@NotNull String type) {
        boolean isArray;
        if (type == null) {
            Type.$$$reportNull$$$0(2);
        }
        String className = (isArray = type.endsWith("[]")) ? type.substring(0, type.length() - 2) : type;
        Type type2 = new Type(className, isArray);
        if (type2 == null) {
            Type.$$$reportNull$$$0(3);
        }
        return type2;
    }

    static boolean conforms(List<? extends Type> actualTypes, List<? extends Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        Iterator<? extends Type> expectedTypeIterator = expectedTypes.iterator();
        for (Type type : actualTypes) {
            if (type.conforms(expectedTypeIterator.next())) continue;
            return false;
        }
        return true;
    }

    boolean conforms(Type expectedType) {
        if (this.isArray() ^ expectedType.isArray()) {
            return false;
        }
        boolean isPrimitive = this.isPrimitive();
        if (isPrimitive ^ expectedType.isPrimitive()) {
            return false;
        }
        if (isPrimitive) {
            return this.myClassName.equals(expectedType.getClassName());
        }
        return true;
    }

    static String simpleName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46);
        return i == -1 ? qualifiedName : qualifiedName.substring(i + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        if (this.myIsArray != type.myIsArray) {
            return false;
        }
        return this.myClassName.equals(type.myClassName);
    }

    public int hashCode() {
        int result = this.myClassName.hashCode();
        result = 31 * result + (this.myIsArray ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/zkm/bytecode/Type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/zkm/bytecode/Type";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

