/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.build.OsmorcBuildTarget;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;

public class OsmorcBuildTargetType
extends ModuleBasedBuildTargetType<OsmorcBuildTarget> {
    public static final OsmorcBuildTargetType INSTANCE = new OsmorcBuildTargetType();

    private OsmorcBuildTargetType() {
        super("osmorc");
    }

    @NotNull
    public List<OsmorcBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            OsmorcBuildTargetType.$$$reportNull$$$0(0);
        }
        ArrayList targets = ContainerUtil.newArrayList();
        for (JpsModule module : model.getProject().getModules()) {
            JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(module);
            if (extension == null) continue;
            targets.add(new OsmorcBuildTarget(extension, module));
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            OsmorcBuildTargetType.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<OsmorcBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            OsmorcBuildTargetType.$$$reportNull$$$0(2);
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            OsmorcBuildTargetType.$$$reportNull$$$0(3);
        }
        return loader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAllTargets";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Loader
    extends BuildTargetLoader<OsmorcBuildTarget> {
        private final Map<String, OsmorcBuildTarget> myTargets = ContainerUtil.newHashMap();

        Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(module);
                if (extension == null) continue;
                this.myTargets.put(module.getName(), new OsmorcBuildTarget(extension, module));
            }
        }

        @Nullable
        public OsmorcBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return this.myTargets.get(targetId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType$Loader", "createTarget"));
        }
    }
}

