/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.velocity.psi.VtlExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VtlExpressionTypeCalculator {
    public static final VtlExpressionTypeCalculator EQUALITY = new VtlExpressionTypeCalculator(){

        @Override
        @Nullable
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            if (leftOperand == null) {
                1.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                1.$$$reportNull$$$0(1);
            }
            return PsiType.BOOLEAN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightOperand";
                    break;
                }
            }
            objectArray[1] = "com/intellij/velocity/psi/VtlExpressionTypeCalculator$1";
            objectArray[2] = "calculateBinary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final VtlExpressionTypeCalculator PLUS_CALCULATOR = new VtlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            PsiType rightType;
            if (leftOperand == null) {
                2.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                2.$$$reportNull$$$0(1);
            }
            if ((rightType = rightOperand.getPsiType()) == null || rightType.equalsToText("java.lang.String")) {
                return rightType;
            }
            PsiType leftType = leftOperand.getPsiType();
            if (leftType == null || leftType.equalsToText("java.lang.String")) {
                return leftType;
            }
            return VtlExpressionTypeCalculator.checkAndReturnNumeric(leftType, rightType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightOperand";
                    break;
                }
            }
            objectArray[1] = "com/intellij/velocity/psi/VtlExpressionTypeCalculator$2";
            objectArray[2] = "calculateBinary";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final VtlExpressionTypeCalculator MINUS_CALCULATOR = new VtlExpressionTypeCalculator(){

        @Override
        public PsiType calculateUnary(@NotNull VtlExpression operand) {
            PsiType type;
            if (operand == null) {
                3.$$$reportNull$$$0(0);
            }
            return (type = operand.getPsiType()) != null && TypeConversionUtil.isNumericType((PsiType)type) ? type : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/velocity/psi/VtlExpressionTypeCalculator$3", "calculateUnary"));
        }
    };
    public static final VtlExpressionTypeCalculator MULTIPLICATIVE_CALCULATOR = new VtlExpressionTypeCalculator(){};

    private VtlExpressionTypeCalculator() {
    }

    @Nullable
    public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
        PsiType rightType;
        if (leftOperand == null) {
            VtlExpressionTypeCalculator.$$$reportNull$$$0(0);
        }
        if (rightOperand == null) {
            VtlExpressionTypeCalculator.$$$reportNull$$$0(1);
        }
        if ((rightType = rightOperand.getPsiType()) == null) {
            return null;
        }
        PsiType leftType = leftOperand.getPsiType();
        if (leftType == null) {
            return null;
        }
        return VtlExpressionTypeCalculator.checkAndReturnNumeric(leftType, rightType);
    }

    @Nullable
    public PsiType calculateUnary(@NotNull VtlExpression expression) {
        if (expression == null) {
            VtlExpressionTypeCalculator.$$$reportNull$$$0(2);
        }
        throw new AssertionError(this);
    }

    private static PsiType checkAndReturnNumeric(PsiType leftType, PsiType rightType) {
        if (TypeConversionUtil.isNumericType((PsiType)leftType) && TypeConversionUtil.isNumericType((PsiType)rightType)) {
            return TypeConversionUtil.unboxAndBalanceTypes((PsiType)leftType, (PsiType)rightType);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/psi/VtlExpressionTypeCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateBinary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateUnary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class BooleanExpressionTypeCalculator
    extends VtlExpressionTypeCalculator {
        private final PsiType myOperandType;

        public BooleanExpressionTypeCalculator(PsiType operandType) {
            this.myOperandType = operandType;
        }

        @Override
        public PsiType calculateBinary(@NotNull VtlExpression leftOperand, @NotNull VtlExpression rightOperand) {
            if (leftOperand == null) {
                BooleanExpressionTypeCalculator.$$$reportNull$$$0(0);
            }
            if (rightOperand == null) {
                BooleanExpressionTypeCalculator.$$$reportNull$$$0(1);
            }
            if (!this.isCorrectOperandType(leftOperand.getPsiType()) || !this.isCorrectOperandType(rightOperand.getPsiType())) {
                return null;
            }
            return PsiType.BOOLEAN;
        }

        private boolean isCorrectOperandType(PsiType opType) {
            return opType == null || this.myOperandType.isConvertibleFrom(opType);
        }

        @Override
        public PsiType calculateUnary(@NotNull VtlExpression operand) {
            if (operand == null) {
                BooleanExpressionTypeCalculator.$$$reportNull$$$0(2);
            }
            if (!this.isCorrectOperandType(operand.getPsiType())) {
                return null;
            }
            return PsiType.BOOLEAN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftOperand";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightOperand";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/velocity/psi/VtlExpressionTypeCalculator$BooleanExpressionTypeCalculator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateBinary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateUnary";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

