/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.client;

import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.intellij.j2ee.webSphere.client.DeployedModuleWrapper;
import com.intellij.j2ee.webSphere.client.DeployedModuleWrapperImpl;
import com.intellij.j2ee.webSphere.client.MBeanWrapperImpl;
import com.intellij.j2ee.webSphere.client.ServerNotificationListener;
import com.intellij.j2ee.webSphere.client.ServerWrapper;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ServerWrapperImpl
extends MBeanWrapperImpl
implements ServerWrapper {
    private static final String SERVER_STARTED_STATE = "STARTED";

    public ServerWrapperImpl(AdminClient adminClient, ObjectName serverObjectName) {
        super(adminClient, serverObjectName);
    }

    public String getState() throws WebSphereClientException {
        return (String)this.getAttribute("state");
    }

    public void checkStarted() throws WebSphereClientException {
        String state = this.getState();
        if (!SERVER_STARTED_STATE.equals(state)) {
            throw new WebSphereClientException("Server: " + state, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
    }

    public void addListener(final ServerNotificationListener listener) throws WebSphereClientException {
        try {
            this.getAdminClient().addNotificationListener(this.getObjectName(), new NotificationListener(){

                public void handleNotification(Notification notification, Object handback) {
                    listener.handleNotification(notification.getMessage());
                }
            }, null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
    }

    public DeployedModuleWrapper[] getDeployedModules() throws WebSphereClientException {
        String[] strings = (String[])this.getAttribute("deployedObjects");
        ArrayList<DeployedModuleWrapperImpl> modules = new ArrayList<DeployedModuleWrapperImpl>();
        try {
            for (String s : strings) {
                ObjectName objectName = new ObjectName(s);
                String type = objectName.getKeyProperty("type");
                if (!this.getAdminClient().isRegistered(objectName) || !"WebModule".equals(type) && !"EJBModule".equals(type)) continue;
                modules.add(new DeployedModuleWrapperImpl(this.getAdminClient(), objectName));
            }
        }
        catch (MalformedObjectNameException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        catch (ConnectorException e) {
            throw new WebSphereClientException((Throwable)e, WebSphereClientExceptionSeverity.SEVERITY_CONNECTOR);
        }
        return modules.toArray(new DeployedModuleWrapper[0]);
    }

    public String getNodeName() throws WebSphereClientException {
        return (String)this.getAttribute("nodeName");
    }

    public String getCellName() throws WebSphereClientException {
        return (String)this.getAttribute("cellName");
    }

    public String getServerName() throws WebSphereClientException {
        return (String)this.getAttribute("name");
    }
}

