/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.BridgeTypedArray;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.icu.text.PluralRules;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LruCache;
import android.util.TypedValue;
import android.view.DisplayAdjustments;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.layoutlib.bridge.util.NinePatchInputStream;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Resources_Delegate {
    private static WeakHashMap<Resources, LayoutlibCallback> sLayoutlibCallbacks = new WeakHashMap();
    private static WeakHashMap<Resources, BridgeContext> sContexts = new WeakHashMap();
    private static boolean[] mPlatformResourceFlag = new boolean[1];
    private static LruCache<String, Drawable.ConstantState> sDrawableCache = new LruCache(50);

    public static Resources initSystem(BridgeContext context, AssetManager assets, DisplayMetrics metrics, Configuration config, LayoutlibCallback layoutlibCallback) {
        assert (Resources.mSystem == null) : "Resources_Delegate.initSystem called twice before disposeSystem was called";
        Resources resources = new Resources(Resources_Delegate.class.getClassLoader());
        resources.setImpl(new ResourcesImpl(assets, metrics, config, new DisplayAdjustments()));
        sContexts.put(resources, Objects.requireNonNull(context));
        sLayoutlibCallbacks.put(resources, Objects.requireNonNull(layoutlibCallback));
        Resources.mSystem = resources;
        return Resources.mSystem;
    }

    public static BridgeContext getContext(Resources resources) {
        assert (sContexts.containsKey(resources)) : "Resources_Delegate.getContext called before initSystem";
        return sContexts.get(resources);
    }

    public static LayoutlibCallback getLayoutlibCallback(Resources resources) {
        assert (sLayoutlibCallbacks.containsKey(resources)) : "Resources_Delegate.getLayoutlibCallback called before initSystem";
        return sLayoutlibCallbacks.get(resources);
    }

    public static void disposeSystem() {
        sDrawableCache.evictAll();
        sContexts.clear();
        sLayoutlibCallbacks.clear();
        Resources.mSystem = null;
    }

    public static BridgeTypedArray newTypeArray(Resources resources, int numEntries, boolean platformFile) {
        return new BridgeTypedArray(resources, Resources_Delegate.getContext(resources), numEntries, platformFile);
    }

    private static Pair<ResourceType, String> getResourceInfo(Resources resources, int id2, boolean[] platformResFlag_out) {
        Pair resourceInfo = Bridge.resolveResourceId(id2);
        assert (Resources.mSystem != null) : "Resources_Delegate.initSystem wasn't called";
        if (!(resources == Resources.mSystem || sContexts.containsKey(resources) && sLayoutlibCallbacks.containsKey(resources))) {
            sLayoutlibCallbacks.put(resources, Resources_Delegate.getLayoutlibCallback(Resources.mSystem));
            sContexts.put(resources, Resources_Delegate.getContext(Resources.mSystem));
        }
        if (resourceInfo != null) {
            platformResFlag_out[0] = true;
            return resourceInfo;
        }
        resourceInfo = Resources_Delegate.getLayoutlibCallback(resources).resolveResourceId(id2);
        if (resourceInfo != null) {
            platformResFlag_out[0] = false;
            return resourceInfo;
        }
        return null;
    }

    private static Pair<String, ResourceValue> getResourceValue(Resources resources, int id2, boolean[] platformResFlag_out) {
        Pair<ResourceType, String> resourceInfo = Resources_Delegate.getResourceInfo(resources, id2, platformResFlag_out);
        if (resourceInfo != null) {
            ResourceValue value;
            String attributeName = (String)resourceInfo.getSecond();
            RenderResources renderResources = Resources_Delegate.getContext(resources).getRenderResources();
            ResourceValue resourceValue = value = platformResFlag_out[0] ? renderResources.getFrameworkResource((ResourceType)resourceInfo.getFirst(), attributeName) : renderResources.getProjectResource((ResourceType)resourceInfo.getFirst(), attributeName);
            if (value == null) {
                value = new ResourceValue((ResourceType)resourceInfo.getFirst(), attributeName, attributeName, platformResFlag_out[0]);
            }
            return Pair.of((Object)attributeName, (Object)value);
        }
        return null;
    }

    @LayoutlibDelegate
    static Drawable getDrawable(Resources resources, int id2) {
        return Resources_Delegate.getDrawable(resources, id2, null);
    }

    @LayoutlibDelegate
    static Drawable getDrawable(Resources resources, int id2, Resources.Theme theme) {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            Drawable drawable2;
            Drawable.ConstantState constantState;
            String key = ((ResourceValue)value.getSecond()).getValue();
            Drawable.ConstantState constantState2 = constantState = key != null ? sDrawableCache.get(key) : null;
            if (constantState != null) {
                drawable2 = constantState.newDrawable(resources, theme);
            } else {
                drawable2 = ResourceHelper.getDrawable((ResourceValue)value.getSecond(), Resources_Delegate.getContext(resources), theme);
                if (key != null) {
                    sDrawableCache.put(key, drawable2.getConstantState());
                }
            }
            return drawable2;
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static int getColor(Resources resources, int id2) {
        return Resources_Delegate.getColor(resources, id2, null);
    }

    @LayoutlibDelegate
    static int getColor(Resources resources, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            ResourceValue resourceValue = (ResourceValue)value.getSecond();
            try {
                return ResourceHelper.getColor(resourceValue.getValue());
            }
            catch (NumberFormatException e) {
                String message;
                if (new File(resourceValue.getValue()).isFile()) {
                    String resource = (resourceValue.isFramework() ? "@android:" : "@") + "color/" + resourceValue.getName();
                    message = "Hexadecimal color expected, found Color State List for " + resource;
                } else {
                    message = e.getMessage();
                }
                Bridge.getLog().error("resources.format", message, (Throwable)e, null);
                return 0;
            }
        }
        return Resources_Delegate.getColorStateList(resources, id2, theme).getDefaultColor();
    }

    @LayoutlibDelegate
    static ColorStateList getColorStateList(Resources resources, int id2) throws Resources.NotFoundException {
        return Resources_Delegate.getColorStateList(resources, id2, null);
    }

    @LayoutlibDelegate
    static ColorStateList getColorStateList(Resources resources, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        ColorStateList stateList;
        Pair<String, ResourceValue> resValue = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (resValue != null && (stateList = ResourceHelper.getColorStateList((ResourceValue)resValue.getSecond(), Resources_Delegate.getContext(resources), theme)) != null) {
            return stateList;
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static CharSequence getText(Resources resources, int id2, CharSequence def) {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return v;
            }
        }
        return def;
    }

    @LayoutlibDelegate
    static CharSequence getText(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                return v;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static CharSequence[] getTextArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue resValue = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (resValue == null) {
            return new CharSequence[0];
        }
        if (!(resValue instanceof ArrayResourceValue)) {
            return new CharSequence[]{Resources_Delegate.resolveReference(resources, resValue.getValue(), resValue.isFramework())};
        }
        ArrayResourceValue arv = (ArrayResourceValue)resValue;
        return Resources_Delegate.fillValues((Resources)resources, (ArrayResourceValue)arv, (CharSequence[])new CharSequence[arv.getElementCount()]);
    }

    @LayoutlibDelegate
    static String[] getStringArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue resValue = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (resValue == null) {
            return new String[0];
        }
        if (!(resValue instanceof ArrayResourceValue)) {
            return new String[]{Resources_Delegate.resolveReference(resources, resValue.getValue(), resValue.isFramework())};
        }
        ArrayResourceValue arv = (ArrayResourceValue)resValue;
        return (String[])Resources_Delegate.fillValues((Resources)resources, (ArrayResourceValue)arv, (CharSequence[])new String[arv.getElementCount()]);
    }

    static <T extends CharSequence> T[] fillValues(Resources resources, ArrayResourceValue resValue, T[] values) {
        int i = 0;
        Iterator iterator = resValue.iterator();
        while (iterator.hasNext()) {
            String s = Resources_Delegate.resolveReference(resources, (String)iterator.next(), resValue.isFramework());
            values[i] = s;
            ++i;
        }
        return values;
    }

    @LayoutlibDelegate
    static int[] getIntArray(Resources resources, int id2) throws Resources.NotFoundException {
        ResourceValue rv = Resources_Delegate.getArrayResourceValue(resources, id2);
        if (rv == null) {
            return new int[0];
        }
        if (!(rv instanceof ArrayResourceValue)) {
            String firstValue = Resources_Delegate.resolveReference(resources, rv.getValue(), rv.isFramework());
            try {
                return new int[]{Resources_Delegate.getInt(firstValue)};
            }
            catch (NumberFormatException e) {
                Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: " + firstValue, null);
                return new int[1];
            }
        }
        ArrayResourceValue resValue = (ArrayResourceValue)rv;
        int[] values = new int[resValue.getElementCount()];
        int i = 0;
        Iterator iterator = resValue.iterator();
        while (iterator.hasNext()) {
            String element = Resources_Delegate.resolveReference(resources, (String)iterator.next(), resValue.isFramework());
            try {
                values[i] = element.startsWith("#") ? Color.parseColor(element) : Resources_Delegate.getInt(element);
            }
            catch (NumberFormatException e) {
                Bridge.getLog().error("resources.format", "Integer resource array contains non-integer value: " + element, null);
            }
            catch (IllegalArgumentException e2) {
                Bridge.getLog().error("resources.format", "Integer resource array contains wrong color format: " + element, null);
            }
            ++i;
        }
        return values;
    }

    private static ResourceValue getArrayResourceValue(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (v != null) {
            ResourceValue resValue = (ResourceValue)v.getSecond();
            assert (resValue != null);
            if (resValue != null) {
                ResourceType type = resValue.getResourceType();
                if (type != ResourceType.ARRAY) {
                    Bridge.getLog().error("resources.resolve", String.format("Resource with id 0x%1$X is not an array resource, but %2$s", id2, type == null ? "null" : type.getDisplayName()), null);
                    return null;
                }
                if (!(resValue instanceof ArrayResourceValue)) {
                    Bridge.getLog().warning("unsupported", "Obtaining resource arrays via getTextArray, getStringArray or getIntArray is not fully supported in this version of the IDE.", null);
                }
                return resValue;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    private static String resolveReference(Resources resources, String ref, boolean forceFrameworkOnly) {
        if (ref.startsWith("@") || ref.startsWith("?")) {
            ResourceValue rv = Resources_Delegate.getContext(resources).getRenderResources().findResValue(ref, forceFrameworkOnly);
            rv = Resources_Delegate.getContext(resources).getRenderResources().resolveResValue(rv);
            if (rv != null) {
                return rv.getValue();
            }
        }
        return ref;
    }

    @LayoutlibDelegate
    static XmlResourceParser getLayout(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.getSecond();
            try {
                return ResourceHelper.getXmlBlockParser(Resources_Delegate.getContext(resources), value);
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to configure parser for " + value.getValue(), (Throwable)e, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static XmlResourceParser getAnimation(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> v = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (v != null) {
            ResourceValue value = (ResourceValue)v.getSecond();
            try {
                return ResourceHelper.getXmlBlockParser(Resources_Delegate.getContext(resources), value);
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to configure parser for " + value.getValue(), (Throwable)e, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static TypedArray obtainAttributes(Resources resources, AttributeSet set, int[] attrs) {
        return Resources_Delegate.getContext(resources).obtainStyledAttributes(set, attrs);
    }

    @LayoutlibDelegate
    static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet set, int[] attrs) {
        return Resources.obtainAttributes_Original(resources, theme, set, attrs);
    }

    @LayoutlibDelegate
    static TypedArray obtainTypedArray(Resources resources, int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @LayoutlibDelegate
    static float getDimension(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                if (v.equals("match_parent") || v.equals("fill_parent")) {
                    return -1.0f;
                }
                if (v.equals("wrap_content")) {
                    return -2.0f;
                }
                TypedValue tmpValue = new TypedValue();
                if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, tmpValue, true) && tmpValue.type == 5) {
                    return tmpValue.getDimension(resources.getDisplayMetrics());
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0.0f;
    }

    @LayoutlibDelegate
    static int getDimensionPixelOffset(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                TypedValue tmpValue = new TypedValue();
                if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, tmpValue, true) && tmpValue.type == 5) {
                    return TypedValue.complexToDimensionPixelOffset(tmpValue.data, resources.getDisplayMetrics());
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static int getDimensionPixelSize(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                TypedValue tmpValue = new TypedValue();
                if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, tmpValue, true) && tmpValue.type == 5) {
                    return TypedValue.complexToDimensionPixelSize(tmpValue.data, resources.getDisplayMetrics());
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static int getInteger(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resValue = (ResourceValue)value.getSecond();
            assert (resValue != null);
            if (resValue != null && (v = resValue.getValue()) != null) {
                try {
                    return Resources_Delegate.getInt(v);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return 0;
    }

    @LayoutlibDelegate
    static boolean getBoolean(Resources resources, int id2) throws Resources.NotFoundException {
        String v;
        ResourceValue resValue;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null && (resValue = (ResourceValue)value.getSecond()) != null && (v = resValue.getValue()) != null) {
            return Boolean.parseBoolean(v);
        }
        Resources_Delegate.throwException(resources, id2);
        return false;
    }

    @LayoutlibDelegate
    static String getResourceEntryName(Resources resources, int resid) throws Resources.NotFoundException {
        Pair<ResourceType, String> resourceInfo = Resources_Delegate.getResourceInfo(resources, resid, new boolean[1]);
        if (resourceInfo != null) {
            return (String)resourceInfo.getSecond();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourceName(Resources resources, int resid) throws Resources.NotFoundException {
        boolean[] platformOut = new boolean[1];
        Pair<ResourceType, String> resourceInfo = Resources_Delegate.getResourceInfo(resources, resid, platformOut);
        if (resourceInfo != null) {
            String packageName;
            packageName = platformOut[0] ? "android" : ((packageName = Resources_Delegate.getContext(resources).getPackageName()) == null ? "app" : packageName);
            return packageName + ':' + ((ResourceType)resourceInfo.getFirst()).getName() + '/' + (String)resourceInfo.getSecond();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourcePackageName(Resources resources, int resid) throws Resources.NotFoundException {
        boolean[] platformOut = new boolean[1];
        Pair<ResourceType, String> resourceInfo = Resources_Delegate.getResourceInfo(resources, resid, platformOut);
        if (resourceInfo != null) {
            if (platformOut[0]) {
                return "android";
            }
            String packageName = Resources_Delegate.getContext(resources).getPackageName();
            return packageName == null ? "app" : packageName;
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getResourceTypeName(Resources resources, int resid) throws Resources.NotFoundException {
        Pair<ResourceType, String> resourceInfo = Resources_Delegate.getResourceInfo(resources, resid, new boolean[1]);
        if (resourceInfo != null) {
            return ((ResourceType)resourceInfo.getFirst()).getName();
        }
        Resources_Delegate.throwException(resid, null);
        return null;
    }

    @LayoutlibDelegate
    static String getString(Resources resources, int id2, Object ... formatArgs) throws Resources.NotFoundException {
        String s = Resources_Delegate.getString(resources, id2);
        if (s != null) {
            return String.format(s, formatArgs);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getString(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null && ((ResourceValue)value.getSecond()).getValue() != null) {
            return ((ResourceValue)value.getSecond()).getValue();
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getQuantityString(Resources resources, int id2, int quantity) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            if (value.getSecond() instanceof PluralsResourceValue) {
                PluralRules pluralRules;
                PluralsResourceValue pluralsResourceValue = (PluralsResourceValue)value.getSecond();
                String strValue = pluralsResourceValue.getValue((pluralRules = PluralRules.forLocale(resources.getConfiguration().getLocales().get(0))).select(quantity));
                if (strValue == null) {
                    strValue = pluralsResourceValue.getValue("other");
                }
                return strValue;
            }
            return ((ResourceValue)value.getSecond()).getValue();
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static String getQuantityString(Resources resources, int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw2 = Resources_Delegate.getQuantityString(resources, id2, quantity);
        return String.format(resources.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    @LayoutlibDelegate
    static CharSequence getQuantityText(Resources resources, int id2, int quantity) throws Resources.NotFoundException {
        return Resources_Delegate.getQuantityString(resources, id2, quantity);
    }

    @LayoutlibDelegate
    static Typeface getFont(Resources resources, int id2) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            return ResourceHelper.getFont((ResourceValue)value.getSecond(), Resources_Delegate.getContext(resources), null);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static Typeface getFont(Resources resources, TypedValue outValue, int id2) throws Resources.NotFoundException {
        Resources_Delegate.getValue(resources, id2, outValue, true);
        if (outValue.string != null) {
            return ResourceHelper.getFont(outValue.string.toString(), Resources_Delegate.getContext(resources), null, mPlatformResourceFlag[0]);
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static void getValue(Resources resources, int id2, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null) {
            String v;
            ResourceValue resVal = (ResourceValue)value.getSecond();
            String string2 = v = resVal != null ? resVal.getValue() : null;
            if (v != null) {
                if (ResourceHelper.parseFloatAttribute((String)value.getFirst(), v, outValue, false)) {
                    return;
                }
                if (resVal instanceof DensityBasedResourceValue) {
                    outValue.density = ((DensityBasedResourceValue)resVal).getResourceDensity().getDpiValue();
                }
                outValue.type = 3;
                outValue.string = v;
                return;
            }
        }
        Resources_Delegate.throwException(resources, id2);
    }

    @LayoutlibDelegate
    static void getValue(Resources resources, String name, TypedValue outValue, boolean resolveRefs) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    @LayoutlibDelegate
    static XmlResourceParser getXml(Resources resources, int id2) throws Resources.NotFoundException {
        File f;
        String v;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null && (v = ((ResourceValue)value.getSecond()).getValue()) != null && (f = new File(v)).isFile()) {
            try {
                XmlPullParser parser = ParserFactory.create(f);
                return new BridgeXmlBlockParser(parser, Resources_Delegate.getContext(resources), mPlatformResourceFlag[0]);
            }
            catch (XmlPullParserException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static XmlResourceParser loadXmlResourceParser(Resources resources, int id2, String type) throws Resources.NotFoundException {
        return resources.loadXmlResourceParser_Original(id2, type);
    }

    @LayoutlibDelegate
    static XmlResourceParser loadXmlResourceParser(Resources resources, String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        File f = new File(file);
        try {
            XmlPullParser parser = ParserFactory.create(f);
            return new BridgeXmlBlockParser(parser, Resources_Delegate.getContext(resources), mPlatformResourceFlag[0]);
        }
        catch (XmlPullParserException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
        catch (FileNotFoundException e) {
            Resources.NotFoundException newE = new Resources.NotFoundException();
            newE.initCause(e);
            throw newE;
        }
    }

    @LayoutlibDelegate
    static InputStream openRawResource(Resources resources, int id2) throws Resources.NotFoundException {
        File f;
        String path;
        Pair<String, ResourceValue> value = Resources_Delegate.getResourceValue(resources, id2, mPlatformResourceFlag);
        if (value != null && (path = ((ResourceValue)value.getSecond()).getValue()) != null && (f = new File(path)).isFile()) {
            try {
                if (path.toLowerCase().endsWith(".9.png")) {
                    return new NinePatchInputStream(f);
                }
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException newE = new Resources.NotFoundException();
                newE.initCause(e);
                throw newE;
            }
        }
        Resources_Delegate.throwException(resources, id2);
        return null;
    }

    @LayoutlibDelegate
    static InputStream openRawResource(Resources resources, int id2, TypedValue value) throws Resources.NotFoundException {
        Resources_Delegate.getValue(resources, id2, value, true);
        String path = value.string.toString();
        File f = new File(path);
        if (f.isFile()) {
            try {
                if (path.toLowerCase().endsWith(".9.png")) {
                    return new NinePatchInputStream(f);
                }
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                Resources.NotFoundException exception = new Resources.NotFoundException();
                exception.initCause(e);
                throw exception;
            }
        }
        throw new Resources.NotFoundException();
    }

    @LayoutlibDelegate
    static AssetFileDescriptor openRawResourceFd(Resources resources, int id2) throws Resources.NotFoundException {
        throw new UnsupportedOperationException();
    }

    static ResourceUrl resourceUrlFromName(String name, String defType, String defPackage) {
        int colonIdx = name.indexOf(58);
        int slashIdx = name.indexOf(47);
        if (colonIdx != -1 && slashIdx != -1) {
            return ResourceUrl.parse((String)("@" + name));
        }
        if (colonIdx == -1 && slashIdx == -1) {
            if (defType == null) {
                throw new IllegalArgumentException("name does not define a type an no defType was passed");
            }
            return ResourceUrl.parse((String)("@" + (defPackage != null ? defPackage + ":" : "") + defType + "/" + name));
        }
        if (colonIdx != -1) {
            if (defType == null) {
                throw new IllegalArgumentException("name does not define a type an no defType was passed");
            }
            String pkg = name.substring(0, colonIdx);
            ResourceType type = ResourceType.getEnum((String)defType);
            return type != null ? ResourceUrl.create((String)pkg, (ResourceType)type, (String)name.substring(colonIdx + 1)) : null;
        }
        ResourceType type = ResourceType.getEnum((String)name.substring(0, slashIdx));
        if (type == null) {
            return null;
        }
        return ResourceUrl.create((String)defPackage, (ResourceType)type, (String)name.substring(slashIdx + 1));
    }

    @LayoutlibDelegate
    static int getIdentifier(Resources resources, String name, String defType, String defPackage) {
        if (name == null) {
            return 0;
        }
        ResourceUrl url = Resources_Delegate.resourceUrlFromName(name, defType, defPackage);
        Integer id2 = null;
        if (url != null) {
            id2 = "android".equals(url.namespace) ? Bridge.getResourceId(url.type, url.name) : Resources_Delegate.getLayoutlibCallback(resources).getResourceId(url.type, url.name);
        }
        return id2 != null ? id2 : 0;
    }

    private static void throwException(Resources resources, int id2) throws Resources.NotFoundException {
        Resources_Delegate.throwException(id2, Resources_Delegate.getResourceInfo(resources, id2, new boolean[1]));
    }

    private static void throwException(int id2, Pair<ResourceType, String> resourceInfo) {
        String message = resourceInfo != null ? String.format("Could not find %1$s resource matching value 0x%2$X (resolved name: %3$s) in current configuration.", resourceInfo.getFirst(), id2, resourceInfo.getSecond()) : String.format("Could not resolve resource value: 0x%1$X.", id2);
        throw new Resources.NotFoundException(message);
    }

    private static int getInt(String v) throws NumberFormatException {
        int radix = 10;
        if (v.startsWith("0x")) {
            v = v.substring(2);
            radix = 16;
        } else if (v.startsWith("0")) {
            radix = 8;
        }
        return Integer.parseInt(v, radix);
    }
}

