/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.StringBlock;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParserException;

class XmlBlock {
    private static final boolean DEBUG = false;
    private final AssetManager mAssets;
    private final long mNative;
    final StringBlock mStrings;
    private boolean mOpen = true;
    private int mOpenCount = 1;

    public XmlBlock(byte[] data) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(data, 0, data.length);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    public XmlBlock(byte[] data, int offset, int size) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(data, offset, size);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        XmlBlock xmlBlock = this;
        synchronized (xmlBlock) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decOpenCountLocked();
            }
        }
    }

    private void decOpenCountLocked() {
        --this.mOpenCount;
        if (this.mOpenCount == 0) {
            XmlBlock.nativeDestroy(this.mNative);
            if (this.mAssets != null) {
                this.mAssets.xmlBlockGone(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlResourceParser newParser() {
        XmlBlock xmlBlock = this;
        synchronized (xmlBlock) {
            if (this.mNative != 0L) {
                return new Parser(XmlBlock.nativeCreateParseState(this.mNative), this);
            }
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    XmlBlock(AssetManager assets, long xmlBlock) {
        this.mAssets = assets;
        this.mNative = xmlBlock;
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(xmlBlock), false);
    }

    private static long nativeCreate(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeL("android.content.res.XmlBlock#nativeCreate([BII)J", true, null);
    }

    private static long nativeGetStringBlock(long l) {
        return OverrideMethod.invokeL("android.content.res.XmlBlock#nativeGetStringBlock(J)J", true, null);
    }

    private static long nativeCreateParseState(long l) {
        return OverrideMethod.invokeL("android.content.res.XmlBlock#nativeCreateParseState(J)J", true, null);
    }

    private static void nativeDestroyParseState(long l) {
        OverrideMethod.invokeV("android.content.res.XmlBlock#nativeDestroyParseState(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.XmlBlock#nativeDestroy(J)V", true, null);
    }

    @FastNative
    static int nativeNext(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeNext(J)I", true, null);
    }

    @FastNative
    private static int nativeGetNamespace(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetNamespace(J)I", true, null);
    }

    @FastNative
    static int nativeGetName(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetName(J)I", true, null);
    }

    @FastNative
    private static int nativeGetText(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetText(J)I", true, null);
    }

    @FastNative
    private static int nativeGetLineNumber(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetLineNumber(J)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeCount(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeCount(J)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeNamespace(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeNamespace(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeName(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeName(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeResource(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeResource(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeDataType(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeDataType(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeData(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeData(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeStringValue(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeStringValue(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetIdAttribute(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetIdAttribute(J)I", true, null);
    }

    @FastNative
    private static int nativeGetClassAttribute(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetClassAttribute(J)I", true, null);
    }

    @FastNative
    private static int nativeGetStyleAttribute(long l) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetStyleAttribute(J)I", true, null);
    }

    @FastNative
    private static int nativeGetAttributeIndex(long l, String string2, String string3) {
        return OverrideMethod.invokeI("android.content.res.XmlBlock#nativeGetAttributeIndex(JLjava/lang/String;Ljava/lang/String;)I", true, null);
    }

    class Parser
    implements XmlResourceParser {
        long mParseState;
        private final XmlBlock mBlock;
        private boolean mStarted = false;
        private boolean mDecNextDepth = false;
        private int mDepth = 0;
        private int mEventType = 0;

        Parser(long parseState, XmlBlock block) {
            this.mParseState = parseState;
            this.mBlock = block;
            block.mOpenCount++;
        }

        @Override
        public void setFeature(String name, boolean state) throws XmlPullParserException {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name) && state) {
                return;
            }
            if ("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name) && state) {
                return;
            }
            throw new XmlPullParserException("Unsupported feature: " + name);
        }

        @Override
        public boolean getFeature(String name) {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(name)) {
                return true;
            }
            return "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(name);
        }

        @Override
        public void setProperty(String name, Object value) throws XmlPullParserException {
            throw new XmlPullParserException("setProperty() not supported");
        }

        @Override
        public Object getProperty(String name) {
            return null;
        }

        @Override
        public void setInput(Reader in) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
            throw new XmlPullParserException("defineEntityReplacementText() not supported");
        }

        @Override
        public String getNamespacePrefix(int pos) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespacePrefix() not supported");
        }

        @Override
        public String getInputEncoding() {
            return null;
        }

        @Override
        public String getNamespace(String prefix) {
            throw new RuntimeException("getNamespace() not supported");
        }

        @Override
        public int getNamespaceCount(int depth) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceCount() not supported");
        }

        @Override
        public String getPositionDescription() {
            return "Binary XML file line #" + this.getLineNumber();
        }

        @Override
        public String getNamespaceUri(int pos) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceUri() not supported");
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getDepth() {
            return this.mDepth;
        }

        @Override
        public String getText() {
            int id2 = XmlBlock.nativeGetText(this.mParseState);
            return id2 >= 0 ? XmlBlock.this.mStrings.get(id2).toString() : null;
        }

        @Override
        public int getLineNumber() {
            return XmlBlock.nativeGetLineNumber(this.mParseState);
        }

        @Override
        public int getEventType() throws XmlPullParserException {
            return this.mEventType;
        }

        @Override
        public boolean isWhitespace() throws XmlPullParserException {
            return false;
        }

        @Override
        public String getPrefix() {
            throw new RuntimeException("getPrefix not supported");
        }

        @Override
        public char[] getTextCharacters(int[] holderForStartAndLength) {
            String txt = this.getText();
            char[] chars = null;
            if (txt != null) {
                holderForStartAndLength[0] = 0;
                holderForStartAndLength[1] = txt.length();
                chars = new char[txt.length()];
                txt.getChars(0, txt.length(), chars, 0);
            }
            return chars;
        }

        @Override
        public String getNamespace() {
            int id2 = XmlBlock.nativeGetNamespace(this.mParseState);
            return id2 >= 0 ? XmlBlock.this.mStrings.get(id2).toString() : "";
        }

        @Override
        public String getName() {
            int id2 = XmlBlock.nativeGetName(this.mParseState);
            return id2 >= 0 ? XmlBlock.this.mStrings.get(id2).toString() : null;
        }

        @Override
        public String getAttributeNamespace(int index) {
            int id2 = XmlBlock.nativeGetAttributeNamespace(this.mParseState, index);
            if (id2 >= 0) {
                return XmlBlock.this.mStrings.get(id2).toString();
            }
            if (id2 == -1) {
                return "";
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public String getAttributeName(int index) {
            int id2 = XmlBlock.nativeGetAttributeName(this.mParseState, index);
            if (id2 >= 0) {
                return XmlBlock.this.mStrings.get(id2).toString();
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public String getAttributePrefix(int index) {
            throw new RuntimeException("getAttributePrefix not supported");
        }

        @Override
        public boolean isEmptyElementTag() throws XmlPullParserException {
            return false;
        }

        @Override
        public int getAttributeCount() {
            return this.mEventType == 2 ? XmlBlock.nativeGetAttributeCount(this.mParseState) : -1;
        }

        @Override
        public String getAttributeValue(int index) {
            int id2 = XmlBlock.nativeGetAttributeStringValue(this.mParseState, index);
            if (id2 >= 0) {
                return XmlBlock.this.mStrings.get(id2).toString();
            }
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, index);
            if (t == 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            int v = XmlBlock.nativeGetAttributeData(this.mParseState, index);
            return TypedValue.coerceToString(t, v);
        }

        @Override
        public String getAttributeType(int index) {
            return "CDATA";
        }

        @Override
        public boolean isAttributeDefault(int index) {
            return false;
        }

        @Override
        public int nextToken() throws XmlPullParserException, IOException {
            return this.next();
        }

        @Override
        public String getAttributeValue(String namespace, String name) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, name);
            if (idx >= 0) {
                return this.getAttributeValue(idx);
            }
            return null;
        }

        @Override
        public int next() throws XmlPullParserException, IOException {
            if (!this.mStarted) {
                this.mStarted = true;
                return 0;
            }
            if (this.mParseState == 0L) {
                return 1;
            }
            int ev = XmlBlock.nativeNext(this.mParseState);
            if (this.mDecNextDepth) {
                --this.mDepth;
                this.mDecNextDepth = false;
            }
            switch (ev) {
                case 2: {
                    ++this.mDepth;
                    break;
                }
                case 3: {
                    this.mDecNextDepth = true;
                }
            }
            this.mEventType = ev;
            if (ev == 1) {
                this.close();
            }
            return ev;
        }

        @Override
        public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
            if (type != this.getEventType() || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
                throw new XmlPullParserException("expected " + TYPES[type] + this.getPositionDescription());
            }
        }

        @Override
        public String nextText() throws XmlPullParserException, IOException {
            if (this.getEventType() != 2) {
                throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", this, null);
            }
            int eventType = this.next();
            if (eventType == 4) {
                String result = this.getText();
                eventType = this.next();
                if (eventType != 3) {
                    throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", this, null);
                }
                return result;
            }
            if (eventType == 3) {
                return "";
            }
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", this, null);
        }

        @Override
        public int nextTag() throws XmlPullParserException, IOException {
            int eventType = this.next();
            if (eventType == 4 && this.isWhitespace()) {
                eventType = this.next();
            }
            if (eventType != 2 && eventType != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": expected start or end tag", this, null);
            }
            return eventType;
        }

        @Override
        public int getAttributeNameResource(int index) {
            return XmlBlock.nativeGetAttributeResource(this.mParseState, index);
        }

        @Override
        public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeListValue(idx, options, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeBooleanValue(idx, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeResourceValue(idx, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeIntValue(idx, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeUnsignedIntValue(idx, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
            int idx = XmlBlock.nativeGetAttributeIndex(this.mParseState, namespace, attribute);
            if (idx >= 0) {
                return this.getAttributeFloatValue(idx, defaultValue);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeListValue(int idx, String[] options, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            int v = XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            if (t == 3) {
                return XmlUtils.convertValueToList(XmlBlock.this.mStrings.get(v), options, defaultValue);
            }
            return v;
        }

        @Override
        public boolean getAttributeBooleanValue(int idx, boolean defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx) != 0;
            }
            return defaultValue;
        }

        @Override
        public int getAttributeResourceValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t == 1) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeIntValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        @Override
        public int getAttributeUnsignedIntValue(int idx, int defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t >= 16 && t <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, idx);
            }
            return defaultValue;
        }

        @Override
        public float getAttributeFloatValue(int idx, float defaultValue) {
            int t = XmlBlock.nativeGetAttributeDataType(this.mParseState, idx);
            if (t == 4) {
                return Float.intBitsToFloat(XmlBlock.nativeGetAttributeData(this.mParseState, idx));
            }
            throw new RuntimeException("not a float!");
        }

        @Override
        public String getIdAttribute() {
            int id2 = XmlBlock.nativeGetIdAttribute(this.mParseState);
            return id2 >= 0 ? XmlBlock.this.mStrings.get(id2).toString() : null;
        }

        @Override
        public String getClassAttribute() {
            int id2 = XmlBlock.nativeGetClassAttribute(this.mParseState);
            return id2 >= 0 ? XmlBlock.this.mStrings.get(id2).toString() : null;
        }

        @Override
        public int getIdAttributeResourceValue(int defaultValue) {
            return this.getAttributeResourceValue(null, "id", defaultValue);
        }

        @Override
        public int getStyleAttribute() {
            return XmlBlock.nativeGetStyleAttribute(this.mParseState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            XmlBlock xmlBlock = this.mBlock;
            synchronized (xmlBlock) {
                if (this.mParseState != 0L) {
                    XmlBlock.nativeDestroyParseState(this.mParseState);
                    this.mParseState = 0L;
                    this.mBlock.decOpenCountLocked();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        CharSequence getPooledString(int id2) {
            return XmlBlock.this.mStrings.get(id2);
        }
    }
}

