/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioMetadata;
import android.hardware.radio.RadioTuner;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

class TunerCallbackAdapter
extends ITunerCallback.Stub {
    private static final String TAG = "BroadcastRadio.TunerCallbackAdapter";
    private final RadioTuner.Callback mCallback;
    private final Handler mHandler;

    TunerCallbackAdapter(RadioTuner.Callback callback, Handler handler) {
        this.mCallback = callback;
        this.mHandler = handler == null ? new Handler(Looper.getMainLooper()) : handler;
    }

    @Override
    public void onError(int status) {
        this.mHandler.post(() -> this.mCallback.onError(status));
    }

    @Override
    public void onConfigurationChanged(RadioManager.BandConfig config) {
        this.mHandler.post(() -> this.mCallback.onConfigurationChanged(config));
    }

    @Override
    public void onCurrentProgramInfoChanged(RadioManager.ProgramInfo info) {
        if (info == null) {
            Log.e(TAG, "ProgramInfo must not be null");
            return;
        }
        this.mHandler.post(() -> {
            this.mCallback.onProgramInfoChanged(info);
            RadioMetadata metadata = info.getMetadata();
            if (metadata != null) {
                this.mCallback.onMetadataChanged(metadata);
            }
        });
    }

    @Override
    public void onTrafficAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onTrafficAnnouncement(active));
    }

    @Override
    public void onEmergencyAnnouncement(boolean active) {
        this.mHandler.post(() -> this.mCallback.onEmergencyAnnouncement(active));
    }

    @Override
    public void onAntennaState(boolean connected) {
        this.mHandler.post(() -> this.mCallback.onAntennaState(connected));
    }

    @Override
    public void onBackgroundScanAvailabilityChange(boolean isAvailable) {
        this.mHandler.post(() -> this.mCallback.onBackgroundScanAvailabilityChange(isAvailable));
    }

    @Override
    public void onBackgroundScanComplete() {
        this.mHandler.post(() -> this.mCallback.onBackgroundScanComplete());
    }

    @Override
    public void onProgramListChanged() {
        this.mHandler.post(() -> this.mCallback.onProgramListChanged());
    }
}

