/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IIpSecService;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransform;
import android.net.IpSecUdpEncapResponse;
import android.net.Network;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.AndroidException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

public class IpSecManager {
    private static final String TAG = "IpSecManager";
    public static final int INVALID_SECURITY_PARAMETER_INDEX = 0;
    public static final int INVALID_RESOURCE_ID = 0;
    private final IIpSecService mService;

    public SecurityParameterIndex reserveSecurityParameterIndex(int direction, InetAddress remoteAddress) throws ResourceUnavailableException {
        try {
            return new SecurityParameterIndex(this.mService, direction, remoteAddress, 0);
        }
        catch (SpiUnavailableException unlikely) {
            throw new ResourceUnavailableException("No SPIs available");
        }
    }

    public SecurityParameterIndex reserveSecurityParameterIndex(int direction, InetAddress remoteAddress, int requestedSpi) throws SpiUnavailableException, ResourceUnavailableException {
        if (requestedSpi == 0) {
            throw new IllegalArgumentException("Requested SPI must be a valid (non-zero) SPI");
        }
        return new SecurityParameterIndex(this.mService, direction, remoteAddress, requestedSpi);
    }

    public void applyTransportModeTransform(Socket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromSocket(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    public void applyTransportModeTransform(DatagramSocket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    public void applyTransportModeTransform(FileDescriptor socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.applyTransportModeTransform(pfd, transform);
        }
    }

    private void applyTransportModeTransform(ParcelFileDescriptor pfd, IpSecTransform transform) {
        try {
            this.mService.applyTransportModeTransform(pfd, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void applyTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    public void removeTransportModeTransform(Socket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromSocket(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    public void removeTransportModeTransform(DatagramSocket socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    public void removeTransportModeTransform(FileDescriptor socket, IpSecTransform transform) throws IOException {
        try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup(socket);){
            this.removeTransportModeTransform(pfd, transform);
        }
    }

    private void removeTransportModeTransform(ParcelFileDescriptor pfd, IpSecTransform transform) {
        try {
            this.mService.removeTransportModeTransform(pfd, transform.getResourceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTunnelModeTransform(Network net, IpSecTransform transform) {
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket(int port) throws IOException, ResourceUnavailableException {
        if (port == 0) {
            throw new IllegalArgumentException("Specified port must be a valid port number!");
        }
        return new UdpEncapsulationSocket(this.mService, port);
    }

    public UdpEncapsulationSocket openUdpEncapsulationSocket() throws IOException, ResourceUnavailableException {
        return new UdpEncapsulationSocket(this.mService, 0);
    }

    public IpSecManager(IIpSecService service) {
        this.mService = Preconditions.checkNotNull(service, "missing service");
    }

    public static class UdpEncapsulationSocket
    implements AutoCloseable {
        private final ParcelFileDescriptor mPfd;
        private final IIpSecService mService;
        private final int mResourceId;
        private final int mPort;
        private final CloseGuard mCloseGuard = CloseGuard.get();

        private UdpEncapsulationSocket(IIpSecService service, int port) throws ResourceUnavailableException, IOException {
            this.mService = service;
            try {
                IpSecUdpEncapResponse result = this.mService.openUdpEncapsulationSocket(port, new Binder());
                switch (result.status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more Sockets may be allocated by this requester.");
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + result.status);
                    }
                }
                this.mResourceId = result.resourceId;
                this.mPort = result.port;
                this.mPfd = result.fileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("constructor");
        }

        public FileDescriptor getSocket() {
            if (this.mPfd == null) {
                return null;
            }
            return this.mPfd.getFileDescriptor();
        }

        public int getPort() {
            return this.mPort;
        }

        @Override
        public void close() throws IOException {
            try {
                this.mService.closeUdpEncapsulationSocket(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            try {
                this.mPfd.close();
            }
            catch (IOException e) {
                Log.e(IpSecManager.TAG, "Failed to close UDP Encapsulation Socket with Port= " + this.mPort);
                throw e;
            }
            this.mCloseGuard.close();
        }

        protected void finalize() throws Throwable {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        int getResourceId() {
            return this.mResourceId;
        }
    }

    public static class SecurityParameterIndex
    implements AutoCloseable {
        private final IIpSecService mService;
        private final InetAddress mRemoteAddress;
        private final CloseGuard mCloseGuard = CloseGuard.get();
        private int mSpi = 0;
        private int mResourceId;

        public int getSpi() {
            return this.mSpi;
        }

        @Override
        public void close() {
            try {
                this.mService.releaseSecurityParameterIndex(this.mResourceId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.close();
        }

        protected void finalize() {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }

        private SecurityParameterIndex(IIpSecService service, int direction, InetAddress remoteAddress, int spi) throws ResourceUnavailableException, SpiUnavailableException {
            this.mService = service;
            this.mRemoteAddress = remoteAddress;
            try {
                IpSecSpiResponse result = this.mService.reserveSecurityParameterIndex(direction, remoteAddress.getHostAddress(), spi, new Binder());
                if (result == null) {
                    throw new NullPointerException("Received null response from IpSecService");
                }
                int status = result.status;
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        throw new ResourceUnavailableException("No more SPIs may be allocated by this requester.");
                    }
                    case 2: {
                        throw new SpiUnavailableException("Requested SPI is unavailable", spi);
                    }
                    default: {
                        throw new RuntimeException("Unknown status returned by IpSecService: " + status);
                    }
                }
                this.mSpi = result.spi;
                this.mResourceId = result.resourceId;
                if (this.mSpi == 0) {
                    throw new RuntimeException("Invalid SPI returned by IpSecService: " + status);
                }
                if (this.mResourceId == 0) {
                    throw new RuntimeException("Invalid Resource ID returned by IpSecService: " + status);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mCloseGuard.open("open");
        }

        int getResourceId() {
            return this.mResourceId;
        }
    }

    public static class ResourceUnavailableException
    extends AndroidException {
        ResourceUnavailableException(String msg) {
            super(msg);
        }
    }

    public static class SpiUnavailableException
    extends AndroidException {
        private final int mSpi;

        SpiUnavailableException(String msg, int spi) {
            super(msg + "(spi: " + spi + ")");
            this.mSpi = spi;
        }

        public int getSpi() {
            return this.mSpi;
        }
    }

    public static interface Status {
        public static final int OK = 0;
        public static final int RESOURCE_UNAVAILABLE = 1;
        public static final int SPI_UNAVAILABLE = 2;
    }
}

