/*
 * Decompiled with CFR 0.152.
 */
package android.security.keymaster;

import android.os.Parcel;
import android.security.keymaster.KeymasterArgument;
import android.security.keymaster.KeymasterDefs;
import java.util.Date;

class KeymasterDateArgument
extends KeymasterArgument {
    public final Date date;

    public KeymasterDateArgument(int tag, Date date) {
        super(tag);
        switch (KeymasterDefs.getTagType(tag)) {
            case 0x60000000: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad date tag " + tag);
            }
        }
        this.date = date;
    }

    public KeymasterDateArgument(int tag, Parcel in) {
        super(tag);
        this.date = new Date(in.readLong());
    }

    @Override
    public void writeValue(Parcel out) {
        out.writeLong(this.date.getTime());
    }
}

