/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier.logging;

import android.content.Context;
import android.metrics.LogMaker;
import android.util.Log;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextSelection;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.UUID;

public class SmartSelectionEventTracker {
    private static final String LOG_TAG = "SmartSelectEventTracker";
    private static final boolean DEBUG_LOG_ENABLED = true;
    private static final int START_EVENT_DELTA = 1117;
    private static final int PREV_EVENT_DELTA = 1118;
    private static final int INDEX = 1120;
    private static final int VERSION_TAG = 1121;
    private static final int SMART_INDICES = 1123;
    private static final int EVENT_INDICES = 1122;
    private static final int SESSION_ID = 1119;
    private static final String ZERO = "0";
    private static final String TEXTVIEW = "textview";
    private static final String EDITTEXT = "edittext";
    private static final String WEBVIEW = "webview";
    private static final String EDIT_WEBVIEW = "edit-webview";
    private static final String UNKNOWN = "unknown";
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private final int mWidgetType;
    private final Context mContext;
    private String mSessionId;
    private final int[] mSmartIndices = new int[2];
    private final int[] mPrevIndices = new int[2];
    private int mOrigStart;
    private int mIndex;
    private long mSessionStartTime;
    private long mLastEventTime;
    private boolean mSmartSelectionTriggered;
    private String mVersionTag;

    public SmartSelectionEventTracker(Context context, int widgetType) {
        this.mWidgetType = widgetType;
        this.mContext = Preconditions.checkNotNull(context);
    }

    public void logEvent(SelectionEvent event) {
        Preconditions.checkNotNull(event);
        if (event.mEventType != 1 && this.mSessionId == null) {
            Log.d(LOG_TAG, "Selection session not yet started. Ignoring event");
            return;
        }
        long now = System_Delegate.currentTimeMillis();
        switch (event.mEventType) {
            case 1: {
                this.mSessionId = this.startNewSession();
                Preconditions.checkArgument(event.mEnd == event.mStart + 1);
                this.mOrigStart = event.mStart;
                this.mSessionStartTime = now;
                break;
            }
            case 3: 
            case 4: {
                this.mSmartSelectionTriggered = true;
                this.mVersionTag = this.getVersionTag(event);
                this.mSmartIndices[0] = event.mStart;
                this.mSmartIndices[1] = event.mEnd;
                break;
            }
            case 2: 
            case 5: {
                if (this.mPrevIndices[0] != event.mStart || this.mPrevIndices[1] != event.mEnd) break;
                return;
            }
        }
        this.writeEvent(event, now);
        if (event.isTerminal()) {
            this.endSession();
        }
    }

    private void writeEvent(SelectionEvent event, long now) {
        long prevEventDelta = this.mLastEventTime == 0L ? 0L : now - this.mLastEventTime;
        LogMaker log = new LogMaker(1100).setType(SmartSelectionEventTracker.getLogType(event)).setSubtype(SmartSelectionEventTracker.getLogSubType(event)).setPackageName(this.mContext.getPackageName()).addTaggedData(1117, now - this.mSessionStartTime).addTaggedData(1118, prevEventDelta).addTaggedData(1120, this.mIndex).addTaggedData(1121, this.mVersionTag).addTaggedData(1123, this.getSmartDelta()).addTaggedData(1122, this.getEventDelta(event)).addTaggedData(1119, this.mSessionId);
        this.mMetricsLogger.write(log);
        SmartSelectionEventTracker.debugLog(log);
        this.mLastEventTime = now;
        this.mPrevIndices[0] = event.mStart;
        this.mPrevIndices[1] = event.mEnd;
        ++this.mIndex;
    }

    private String startNewSession() {
        this.endSession();
        this.mSessionId = SmartSelectionEventTracker.createSessionId();
        return this.mSessionId;
    }

    private void endSession() {
        this.mOrigStart = 0;
        this.mSmartIndices[1] = 0;
        this.mSmartIndices[0] = 0;
        this.mPrevIndices[1] = 0;
        this.mPrevIndices[0] = 0;
        this.mIndex = 0;
        this.mSessionStartTime = 0L;
        this.mLastEventTime = 0L;
        this.mSmartSelectionTriggered = false;
        this.mVersionTag = this.getVersionTag(null);
        this.mSessionId = null;
    }

    private static int getLogType(SelectionEvent event) {
        switch (event.mEventType) {
            case 100: {
                return 1108;
            }
            case 101: {
                return 1109;
            }
            case 102: {
                return 1110;
            }
            case 103: {
                return 1111;
            }
            case 104: {
                return 1112;
            }
            case 105: {
                return 1113;
            }
            case 106: {
                return 1114;
            }
            case 107: {
                return 1115;
            }
            case 108: {
                return 1116;
            }
            case 200: {
                return 1103;
            }
            case 201: {
                return 1104;
            }
            case 1: {
                return 1101;
            }
            case 2: {
                return 1102;
            }
            case 3: {
                return 1105;
            }
            case 4: {
                return 1106;
            }
            case 5: {
                return 1107;
            }
        }
        return 0;
    }

    private static String getLogTypeString(int logType) {
        switch (logType) {
            case 1108: {
                return "OVERTYPE";
            }
            case 1109: {
                return "COPY";
            }
            case 1110: {
                return "PASTE";
            }
            case 1111: {
                return "CUT";
            }
            case 1112: {
                return "SHARE";
            }
            case 1113: {
                return "SMART_SHARE";
            }
            case 1114: {
                return "DRAG";
            }
            case 1115: {
                return "ABANDON";
            }
            case 1116: {
                return "OTHER";
            }
            case 1103: {
                return "SELECT_ALL";
            }
            case 1104: {
                return "RESET";
            }
            case 1101: {
                return "SELECTION_STARTED";
            }
            case 1102: {
                return "SELECTION_MODIFIED";
            }
            case 1105: {
                return "SMART_SELECTION_SINGLE";
            }
            case 1106: {
                return "SMART_SELECTION_MULTI";
            }
            case 1107: {
                return "AUTO_SELECTION";
            }
        }
        return UNKNOWN;
    }

    private static int getLogSubType(SelectionEvent event) {
        switch (event.mEntityType) {
            case "other": {
                return 2;
            }
            case "email": {
                return 3;
            }
            case "phone": {
                return 4;
            }
            case "address": {
                return 5;
            }
            case "url": {
                return 6;
            }
        }
        return 1;
    }

    private static String getLogSubTypeString(int logSubType) {
        switch (logSubType) {
            case 2: {
                return "other";
            }
            case 3: {
                return "email";
            }
            case 4: {
                return "phone";
            }
            case 5: {
                return "address";
            }
            case 6: {
                return "url";
            }
        }
        return "";
    }

    private int getSmartDelta() {
        if (this.mSmartSelectionTriggered) {
            return SmartSelectionEventTracker.clamp(this.mSmartIndices[0] - this.mOrigStart) << 16 | SmartSelectionEventTracker.clamp(this.mSmartIndices[1] - this.mOrigStart) & 0xFFFF;
        }
        return 0;
    }

    private int getEventDelta(SelectionEvent event) {
        return SmartSelectionEventTracker.clamp(event.mStart - this.mOrigStart) << 16 | SmartSelectionEventTracker.clamp(event.mEnd - this.mOrigStart) & 0xFFFF;
    }

    private String getVersionTag(SelectionEvent event) {
        String widgetType;
        switch (this.mWidgetType) {
            case 1: {
                widgetType = TEXTVIEW;
                break;
            }
            case 2: {
                widgetType = WEBVIEW;
                break;
            }
            case 3: {
                widgetType = EDITTEXT;
                break;
            }
            case 4: {
                widgetType = EDIT_WEBVIEW;
                break;
            }
            default: {
                widgetType = UNKNOWN;
            }
        }
        String version = event == null ? "" : Objects.toString(event.mVersionTag, "");
        return String.format("%s/%s", widgetType, version);
    }

    private static String createSessionId() {
        return UUID.randomUUID().toString();
    }

    private static int clamp(int val) {
        return Math.max(Math.min(val, Short.MAX_VALUE), Short.MIN_VALUE);
    }

    private static void debugLog(LogMaker log) {
        String tag = Objects.toString(log.getTaggedData(1121), "tag");
        int index = Integer.parseInt(Objects.toString(log.getTaggedData(1120), ZERO));
        if (log.getType() == 1101) {
            String sessionId = Objects.toString(log.getTaggedData(1119), "");
            sessionId = sessionId.substring(sessionId.lastIndexOf("-") + 1);
            Log.d(LOG_TAG, String.format("New selection session: %s(%s)", tag, sessionId));
        }
        String type = SmartSelectionEventTracker.getLogTypeString(log.getType());
        String subType = SmartSelectionEventTracker.getLogSubTypeString(log.getSubtype());
        int smartIndices = Integer.parseInt(Objects.toString(log.getTaggedData(1123), ZERO));
        short smartStart = (short)((smartIndices & 0xFFFF0000) >> 16);
        short smartEnd = (short)(smartIndices & 0xFFFF);
        int eventIndices = Integer.parseInt(Objects.toString(log.getTaggedData(1122), ZERO));
        short eventStart = (short)((eventIndices & 0xFFFF0000) >> 16);
        short eventEnd = (short)(eventIndices & 0xFFFF);
        Log.d(LOG_TAG, String.format("%2d: %s/%s, context=%d,%d - old=%d,%d (%s)", index, type, subType, (int)eventStart, (int)eventEnd, (int)smartStart, (int)smartEnd, tag));
    }

    public static class SelectionEvent {
        public static final int OUT_OF_BOUNDS = Short.MAX_VALUE;
        public static final int OUT_OF_BOUNDS_NEGATIVE = Short.MIN_VALUE;
        private static final String NO_VERSION_TAG = "";
        private final int mStart;
        private final int mEnd;
        private int mEventType;
        private final String mEntityType;
        private final String mVersionTag;

        private SelectionEvent(int start, int end, int eventType, String entityType, String versionTag) {
            Preconditions.checkArgument(end >= start, "end cannot be less than start");
            this.mStart = start;
            this.mEnd = end;
            this.mEventType = eventType;
            this.mEntityType = Preconditions.checkNotNull(entityType);
            this.mVersionTag = Preconditions.checkNotNull(versionTag);
        }

        public static SelectionEvent selectionStarted(int start) {
            return new SelectionEvent(start, start + 1, 1, NO_VERSION_TAG, NO_VERSION_TAG);
        }

        public static SelectionEvent selectionModified(int start, int end) {
            return new SelectionEvent(start, end, 2, NO_VERSION_TAG, NO_VERSION_TAG);
        }

        public static SelectionEvent selectionModified(int start, int end, TextClassification classification) {
            String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : NO_VERSION_TAG;
            String versionTag = classification.getVersionInfo();
            return new SelectionEvent(start, end, 2, entityType, versionTag);
        }

        public static SelectionEvent selectionModified(int start, int end, TextSelection selection) {
            boolean smartSelection = selection.getSourceClassifier().equals("TextClassifierImpl");
            int eventType = smartSelection ? (end - start > 1 ? 4 : 3) : 5;
            String entityType = selection.getEntityCount() > 0 ? selection.getEntity(0) : NO_VERSION_TAG;
            String versionTag = selection.getVersionInfo();
            return new SelectionEvent(start, end, eventType, entityType, versionTag);
        }

        public static SelectionEvent selectionAction(int start, int end, int actionType) {
            return new SelectionEvent(start, end, actionType, NO_VERSION_TAG, NO_VERSION_TAG);
        }

        public static SelectionEvent selectionAction(int start, int end, int actionType, TextClassification classification) {
            String entityType = classification.getEntityCount() > 0 ? classification.getEntity(0) : NO_VERSION_TAG;
            String versionTag = classification.getVersionInfo();
            return new SelectionEvent(start, end, actionType, entityType, versionTag);
        }

        private boolean isActionType() {
            switch (this.mEventType) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 200: 
                case 201: {
                    return true;
                }
            }
            return false;
        }

        private boolean isTerminal() {
            switch (this.mEventType) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return true;
                }
            }
            return false;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        private static @interface EventType {
            public static final int SELECTION_STARTED = 1;
            public static final int SELECTION_MODIFIED = 2;
            public static final int SMART_SELECTION_SINGLE = 3;
            public static final int SMART_SELECTION_MULTI = 4;
            public static final int AUTO_SELECTION = 5;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ActionType {
            public static final int OVERTYPE = 100;
            public static final int COPY = 101;
            public static final int PASTE = 102;
            public static final int CUT = 103;
            public static final int SHARE = 104;
            public static final int SMART_SHARE = 105;
            public static final int DRAG = 106;
            public static final int ABANDON = 107;
            public static final int OTHER = 108;
            public static final int SELECT_ALL = 200;
            public static final int RESET = 201;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetType {
        public static final int UNSPECIFIED = 0;
        public static final int TEXTVIEW = 1;
        public static final int WEBVIEW = 2;
        public static final int EDITTEXT = 3;
        public static final int EDIT_WEBVIEW = 4;
    }
}

